package com.zbkj.service.wangshang.api.domain.model;


import com.zbkj.service.wangshang.api.domain.RequestBody;
import com.zbkj.service.wangshang.api.internal.util.CDataAdapter;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * 商户余额查询接口< ant.mybank.bkcloudfunds.balance.query>
 * 请求模型
 * <p>
 * 通过此接口，可以查询商户在网商的各项余额。目前含如下两个余额：
 * FREEZE-表示当前处于冻结（未分账）的余额。
 * BALANCE-标识当前可用于提现或余额支付的余额。
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class BkcloudfundsBalanceQueryRequestModel extends RequestBody {

    private static final long serialVersionUID = 7905821387293073953L;
    /**
     * 合作方机构号
     * <p>
     * 网商银行分配
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 商户号
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "MerchantId")
    private String merchantId;

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }
}