package com.zbkj.service.wangshang.api.domain.model;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <b> 绑定结算卡详情 </b>
 * @author ZXF
 * @create 2025/06/09 0009 13:32
 * @version
 * @注意事项 </b>
 */
@Data
public class BankCardParam implements Serializable {
    @ApiModelProperty(value = "银行卡号")
    @JSONField(name = "BankCardNo")
    private String bankCardNo;
    @ApiModelProperty(value = "银行账户户名")
    @JSONField(name = "BankCertName")
    private String bankCertName;
    @ApiModelProperty(value = "账户类型 02：对公账户")
    @JSONField(name = "AccountType")
    private String accountType;
    @ApiModelProperty(value = "负责人证件类型")
    @JSONField(name = "PrincipalCertType")
    private String principalCertType = "01";
    @ApiModelProperty(value = "联行号")
    @JSONField(name = "ContactLine")
    private String contactLine;
    @ApiModelProperty(value = "开户支行名称")
    @JSONField(name = "BranchName")
    private String branchName;
    @ApiModelProperty(value = "开户支行所在省")
    @JSONField(name = "BranchProvince")
    private String branchProvince;
    @ApiModelProperty(value = "开户支行所在市")
    @JSONField(name = "BranchCity")
    private String branchCity;
    @ApiModelProperty(value = "持卡人证件类型 01：身份证 对公账户不需要填写")
    @JSONField(name = "CertType")
    private String certType;
    @ApiModelProperty(value = "持卡人证件号码 对公账户不需要填写")
    @JSONField(name = "CertNo")
    private String certNo;
    @ApiModelProperty(value = "持卡人地址 对公账户不需要填写")
    @JSONField(name = "CardHolderAddress")
    private String cardHolderAddress;
    @ApiModelProperty(value = "支付宝登陆账号")
    @JSONField(name = "LogonId")
    private String logonId;
    @ApiModelProperty(value = "结算类型。可选值：01：银行卡 02: 支付宝")
    @JSONField(name = "SettlementAccountType")
    private String settlementAccountType;

}
