package com.zbkj.service.service.bcx;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bcx.BcxOrderFapiao;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.bcx.BcxOrderFapiaoQueryRequest;
import com.zbkj.common.request.bcx.BcxOrderFapiaoRequest;
import com.zbkj.common.request.bcx.BcxWriteFapiaoRequest;
import com.zbkj.common.response.bcx.BcxOrderFapiaoResponse;

import java.util.List;

/**
 * 订单发票表 服务接口
 */
public interface BcxOrderFapiaoService extends IService<BcxOrderFapiao> {

    BcxOrderFapiaoResponse queryById(Integer id);

    PageInfo<BcxOrderFapiaoResponse> queryPagedList(String orderNo,
                                                    PageParamRequest pageParamRequest);

    PageInfo<BcxOrderFapiaoResponse> queryMerchantFapiaoPagedList(Integer merId, BcxOrderFapiaoQueryRequest request,
                                                                  PageParamRequest pageParamRequest);

    PageInfo<BcxOrderFapiaoResponse> queryPlatformFapiaoPagedList(BcxOrderFapiaoQueryRequest request,
                                                                  PageParamRequest pageParamRequest);

    BcxOrderFapiao create(BcxOrderFapiaoRequest bcxOrderFapiao);
    Boolean update(BcxOrderFapiaoRequest bcxOrderFapiao);
    Boolean delete(Integer id);

    boolean writeFapiao(BcxWriteFapiaoRequest request, Integer merId);

    BcxOrderFapiao getFapiaoByOrderNo(String orderNo);
}
