package com.zbkj.service.service;

import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.model.user.User;
import com.zbkj.common.request.OrderPayRequest;
import com.zbkj.common.request.bcx.BcxMerchantPayOfflineRequest;
import com.zbkj.common.request.bcx.OrderModifyPriceRequest;
import com.zbkj.common.response.OrderPayResultResponse;
import com.zbkj.common.response.PayConfigResponse;
import com.zbkj.common.vo.MyRecord;

import java.util.List;
import java.util.Map;

/**
 * PayService 接口
 * +----------------------------------------------------------------------
 * | CRMEB [ CRMEB赋能开发者，助力企业发展 ]
 * +----------------------------------------------------------------------
 * | Copyright (c) 2016~2023 https://www.crmeb.com All rights reserved.
 * +----------------------------------------------------------------------
 * | Licensed CRMEB并不是自由软件，未经许可不能去掉CRMEB相关版权
 * +----------------------------------------------------------------------
 * | Author: CRMEB Team <admin@crmeb.com>
 * +----------------------------------------------------------------------
 */
public interface PayService {

    /**
     * 发送短信验证码
     * @param phone 手机号
     * @return Boolean
     */
    Boolean sendWalletCode(String phone);

    /**
     * 获取支付配置
     */
    PayConfigResponse getPayConfig();

    /**
     * <b> 根据订单号获取商户identify_no和订单金额 </b>
     * @author ZXF
     * @create 2024/02/29 0029 10:40
     * @version
     * @注意事项 </b>
     */
    Map<String,String> getIdentifyNoByOrderNo(String orderNo);

    /**
     * 订单支付
     * @param orderPayRequest 订单支付参数
     * @return OrderPayResultResponse
     */
    OrderPayResultResponse payment(OrderPayRequest orderPayRequest);

    /**
     * 查询订单微信支付结果
     * @param orderNo 订单编号
     */
    Boolean queryWechatPayResult(String orderNo);

    /**
     * 查询订单支付宝支付结果
     * @param orderNo 订单编号
     */
    Boolean queryAliPayResult(String orderNo);

    /**
     * 支付成功后置处理
     * @param orderNo 订单编号
     */
    Boolean payAfterProcessing(String orderNo);

    /**
     * 支付成功后置处理(临时)
     * @param orderNo 订单编号
     */
    Boolean payAfterProcessingTemp(String orderNo);

    /**
     * 提供给汇付微信支付控件，当确定微信支付成功后，调用该方法设置订单状态为已支付
     * @param orderNo
     */
    void setOrderPaySuccess(String orderNo);

    Boolean specialOrderUnfreezeAndPay(String orderNo);

    Boolean walletUnfreezeAndPay(Order order, List<OrderDetail> orderDetails, Integer type, User user, Merchant merchant);

    Boolean platWalletUnfreezeAndPay(Order order, List<OrderDetail> orderDetails, Integer type, User user, Merchant merchant);

    Boolean walletUnfreeze(Order order, List<OrderDetail> orderDetails, Integer type, User user, Merchant merchant);

    Boolean wechat2HuifuRefund(Order order);

    boolean checkPayResult(String orderNo);

    /**
     * <b> C端聚合正扫回调 </b>
     * @author ZXF
     * @create 2023/08/25 0025 16:13
     * @version
     * @注意事项 </b>
     */
    String huifuJspayCallback(String messageBody);
    /**
     * <b> C端聚合正扫退款回调 </b>
     * @author ZXF
     * @create 2023/08/25 0025 16:13
     * @version
     * @注意事项 </b>
     */
    String huifuJspayRefundCallback(String messageBody);

    String getMerchantIdentifyNoByOrderNo(String orderNo);

    void allOrder(String orderNo);

    boolean payOffline(BcxMerchantPayOfflineRequest request);

    /**
     * description：确认到款
     * author：linchunpeng
     * date：2025/8/12
     */
    boolean payOfflineReceived(BcxMerchantPayOfflineRequest request);
}
