package com.zbkj.service.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bcx.BcxDepartmentMember;
import com.zbkj.common.request.BcxDepartmentMemberSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.BcxDepartmentMemberResponse;
import com.zbkj.common.response.BcxDepartmentResponse;

import java.util.List;

/**
 * description: 部门成员表 服务接口
 * author : linchunpeng
 * date : 2023/8/3
 */
public interface BcxDepartmentMemberService extends IService<BcxDepartmentMember> {

    /**
     * description：获取部门成员tree列表
     * author：linchunpeng
     * date：2023/8/7
     */
    List<BcxDepartmentResponse> findAllTree();

    /**
     * description：根据v5id查询部门成员
     * author：linchunpeng
     * date：2023/8/21
     */
    BcxDepartmentMember findByBcxId(String bcxId);

    /**
     * description：分页查询部门成员列表
     * author：linchunpeng
     * date：2023/8/25
     */
    PageInfo<BcxDepartmentMemberResponse> getPage(BcxDepartmentMemberSearchRequest request, PageParamRequest pageParamRequest);

    String getMemerNamesByUid(Integer uid);
}