package com.zbkj.service.huifu.v2;

import java.util.*;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huifu.bspay.sdk.opps.core.utils.SequenceTools;
import com.huifu.bspay.sdk.opps.core.request.V2TradeCheckReplayRequest;
import com.zbkj.service.huifu.constants.HFProfileConstants;
import com.zbkj.service.huifu.core.Identify;

/**
 * 交易结算对账文件重新生成 - 示例
 *
 * @author sdk-generator
 * @Description
 */
@Identify(requestClass = V2TradeCheckReplayRequest.class)
public class V2TradeCheckReplay {

    public static V2TradeCheckReplayRequest method(Map<String, Object> map) {

        // 2.组装请求参数
        V2TradeCheckReplayRequest request = JSONObject.parseObject(JSON.toJSONString(map),V2TradeCheckReplayRequest.class);
        // 请求流水号
        request.setReqSeqId(SequenceTools.getReqSeqId32());
        // 交易日期
//        request.setReqDate(DateTools.getCurrentDateYYYYMMDD());
        // 汇付机构编号
//        request.setHuifuId(HFProfileConstants.HUIFU_ID);
        // 文件类型
//        request.setFileType("1");

        // 设置非必填字段
        Map<String, Object> extendInfoMap = getExtendInfos();
        request.setExtendInfo(extendInfoMap);
        return request;
    }

    /**
     * 非必填字段
     * @return
     */
    private static Map<String, Object> getExtendInfos() {
        // 设置非必填字段
        Map<String, Object> extendInfoMap = new HashMap<>();
        return extendInfoMap;
    }

}
