package com.zbkj.service.huifu.v2;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huifu.bspay.sdk.opps.core.request.V2TradeAcctpaymentAcctlogQueryRequest;
import com.zbkj.service.huifu.core.Identify;

import java.util.HashMap;
import java.util.Map;

/**
 * 账务流水查询 - 示例
 *
 * @author sdk-generator
 * @Description
 */
@Identify(requestClass = V2TradeAcctpaymentAcctlogQueryRequest.class)
public class V2TradeAcctpaymentAcctlogQuery {

    public static V2TradeAcctpaymentAcctlogQueryRequest method(Map<String, Object> map) {

        // 2.组装请求参数
        V2TradeAcctpaymentAcctlogQueryRequest request = JSONObject.parseObject(JSON.toJSONString(map),V2TradeAcctpaymentAcctlogQueryRequest.class);
//        V2TradeAcctpaymentAcctlogQueryRequest request = new V2TradeAcctpaymentAcctlogQueryRequest();
        // 请求流水号
//        request.setReqSeqId(SequenceTools.getReqSeqId32());
        // 渠道/代理/商户/用户编号
//        request.setHuifuId("6666000108854952");
        // 账务日期
//        request.setAcctDate("20220816");

        // 设置非必填字段
        Map<String, Object> extendInfoMap = getExtendInfos(map);
        request.setExtendInfo(extendInfoMap);
        return request;
    }

    /**
     * 非必填字段
     * @return
     */
    private static Map<String, Object> getExtendInfos(Map<String, Object> map) {
        // 设置非必填字段
        Map<String, Object> extendInfoMap = new HashMap<>();
        // 每页条数
        extendInfoMap.put("page_size", map.get("pageSize"));
        // 分页页码
        extendInfoMap.put("page_num", map.get("pageNum"));
        // 账户号
        // extendInfoMap.put("acct_id", "");
        return extendInfoMap;
    }

}
