package com.zbkj.service.huifu.v2;

import com.alibaba.fastjson.JSONObject;
import com.zbkj.service.huifu.constants.HFBusiCode;
import com.zbkj.service.huifu.init.CoppsMerchantConfig;
import com.zbkj.service.huifu.init.OppsMerchantConfig;

import java.util.Map;


public class V2ApiRequest extends BaseCommon {

    public final static String MERCHANTKEY = "plat_c_pay";

    static {
        // 1. 数据初始化
        try {
            doInit(OppsMerchantConfig.getMerchantConfig());
            //添加C端商户配置
            addMerConfig(CoppsMerchantConfig.getMerchantConfig(),MERCHANTKEY);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> api(HFBusiCode code,Map<String, Object> map) throws Exception {
        Map<String, Object> response;
        // 3. 发起API调用
        switch (code) {
            case JSQUERY:
                response = doExecute(V2MerchantBasicdataSettlementQuery.method(map));
                break;
            case CWQUERY:
                response = doExecute(V2TradeAcctpaymentAcctlogQuery.method(map));
                break;
            case JYFZQUERY:
                response = doExecute(V2TradeTransSplitQuery.method(map));
                break;
            case YEQUERY:
                response = doExecute(V2TradeAcctpaymentBalanceQuery.method(map));
                break;
            case YEPAY:
                response = doExecute(V2TradeAcctpaymentPay.method(map));
                break;
            case ZDCONFIG:
                response = doExecute(V2MerchantBusiBillConfig.method(map));
                break;
            case ZDREPLAY:
                response = doExecute(V2TradeCheckReplay.method(map));
                break;
            case ZDQUERY:
                response = doExecute(V2TradeCheckFilequery.method(map));
                break;
            case TXQUERY:
                response = doExecute(V2TradeBatchtranslogQuery.method(map));
                break;
            case WYPAY:
                response = doExecute(V2TradeOnlinepaymentBankingFrontpay.method(map));
                break;
            case HDQUERY:
                response = doExecute(V2TradePaymentGetelectronicreceipt.method(map));
                break;
            case ENCHASHMENT:
                response = doExecute(V2TradeSettlementEnchashment.method(map));
                break;
            case ENT:
                response = doExecute(V2UserBasicdataEnt.method(map));
                break;
            case ENTMODIFY:
                response = doExecute(V2UserBasicdataEntModify.method(map));
                break;
            case YHQUERY:
                response = doExecute(V2UserBasicdataQuery.method(map));
                break;
            case BUSIMODIFY:
                response = doExecute(V2UserBusiModify.method(map));
                break;
            case BUSIOPEN:
                response = doExecute(V2UserBusiOpen.method(map));
                break;
            case APQUERY:
                response = doExecute(V2TradeAcctpaymentPayQuery.method(map));
                break;
            case JSPAY:
                response = doExecute(V2TradePaymentJspay.method(map),MERCHANTKEY);
                break;
            case SCANPAYQUERY:
                response = doExecute(V2TradePaymentScanpayQuery.method(map),MERCHANTKEY);
                break;
            case SCANPAYREFUND:
                response = doExecute(V2TradePaymentScanpayRefund.method(map),MERCHANTKEY);
                break;
            case REFUNDQUERY:
                response = doExecute(V2TradePaymentScanpayRefundquery.method(map),MERCHANTKEY);
                break;
            default:
                response = null;
        }
        System.out.println("返回数据:" + JSONObject.toJSONString(response));
        return response;
    }

}
