/**
 * Copyright (c) 2011-2014, hubin (jobob@qq.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.zbkj.service.huifu.constants;

/**
 * <b> 开户步骤 </b>
 * @author ZXF
 * @create 2023/08/02 0002 16:37
 * @version
 * @注意事项 </b>
 */
public enum OpenProcess {
	QYKH("BasicdataEnt", 1, "企业基本信息录入"),
	YWRZ("RegistrationApplication", 2, "入驻申请中"),
	SHJHZ("MerchantActivation", 3, "商户激活中");

	private final String cla;
	private final int sort;

	private final String desc;

	OpenProcess(final String cla, final int sort, final String desc) {
		this.cla = cla;
		this.sort = sort;
		this.desc = desc;
	}

	/**
	 * <p>
	 * 获取优化类型.如果没有找到默认null
	 * </p>
	 * 
	 * @param openProcessCla
	 *            优化方式
	 * @return
	 */
	public static OpenProcess getOpenProcessCla(String openProcessCla) {
		for (OpenProcess openProcess : OpenProcess.values()) {
			if (openProcess.getCla().equalsIgnoreCase(openProcessCla)) {
				return openProcess;
			}
		}
		return null;
	}

	public String getCla() {
		return this.cla;
	}

	public int getSort() {
		return this.sort;
	}

	public String getDesc() {
		return this.desc;
	}

}
