/**
 * Copyright (c) 2011-2014, hubin (jobob@qq.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.zbkj.service.huifu.constants;

/**
 * <b> 汇付支付业务接口标识 </b>
 * @author ZXF
 * @create 2023/08/02 0002 16:37
 * @version
 * @注意事项 </b>
 */
public enum CTradeType {
	T_JSAPI("T_JSAPI", "微信公众号"),
	T_MINIAPP("T_MINIAPP", "微信小程序"),
	A_JSAPI("A_JSAPI", "支付宝JS"),
	A_NATIVE("A_NATIVE", "支付宝正扫"),
	T_H5("T_H5", "微信直连H5支付"),
	T_APP("T_APP", "微信APP支付（只支持直连）"),
	T_NATIVE("T_NATIVE", "微信正扫（只支持直连）");

	private final String value;

	private final String lable;

	CTradeType(final String value, final String lable) {
		this.value = value;
		this.lable = lable;
	}

	/**
	 * <p>
	 * 获取优化类型.如果没有找到默认null
	 * </p>
	 * 
	 * @param cTradeTypeValue
	 *            优化方式
	 * @return
	 */
	public static CTradeType getHFBusiCodeCla(String cTradeTypeValue) {
		for (CTradeType cTradeType : CTradeType.values()) {
			if (cTradeType.getValue().equalsIgnoreCase(cTradeTypeValue)) {
				return cTradeType;
			}
		}
		return null;
	}

	public String getValue() {
		return this.value;
	}

	public String getLable() {
		return this.lable;
	}

}
