package com.zbkj.service.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zbkj.common.model.order.VirtualOrder;
import com.zbkj.common.response.VirtualOrderResponse;
import org.springframework.data.repository.query.Param;

import java.util.List;
import java.util.Map;

/**
 * <b> 虚拟订单表 Mapper 接口 </b>
 * @author ZXF
 * @create 2025/08/26 0026 10:42
 * @version
 * @注意事项 </b>
 */
public interface VirtualOrderDao extends BaseMapper<VirtualOrder> {

    /**
     * 虚拟订单
     * @param virtualOrderNo 虚拟订单号
     * @return VirtualOrderResponse
     */
    VirtualOrderResponse getVirtualOrderByVirtualOrderNo(@Param("virtualOrderNo") String virtualOrderNo);
    List<VirtualOrderResponse> queryVirtualOrderList(Map<String, Object> queryParam);
    /**
     * 获取用户存在剩余可用数量的记录按id升序
     * @param uid 用户id
     * @return 虚拟订单列表
     */
    List<VirtualOrderResponse> queryExistAvailableNumByUid(@Param("uid") Integer uid);
    /**
     * 获取用户剩余可用数量
     * @param uid 用户id
     * @return 剩余可用数量
     */
    int countAvailableNumByUid(@Param("uid") Integer uid);
    /**
     * <b> 根据类型修改数量 </b>
     * @author ZXF
     * @create 2025/08/26 0026 14:54
     * @version
     * @注意事项 </b>
     */
    int updateNumByType(VirtualOrderResponse orderResponse);
}
