package com.zbkj.service.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zbkj.common.dto.HuifuWalletTradeDto;
import com.zbkj.common.model.huifu.HuifuWalletReconciliation;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * <b>  </b>
 * @author ZXF
 * @create 2023/07/31 0031 11:08
 * @version
 * @注意事项 </b>
 */
public interface HuifuWalletReconciliationDao extends BaseMapper<HuifuWalletReconciliation> {

    /**
     * 插入临时企业钱包对账数据
     *
     * @param list
     * @return
     * @author llc
     * @date 2019-09-17
     */
    int insertTempReconciliationList(@Param("list") List<HuifuWalletReconciliation> list);


    /**
     * 插入企业钱包对账数据
     *
     * @return
     * @author llc
     * @date 2019-09-18
     */
    int insertHuifuWalletReconciliation(@Param("tradeDate") String tradeDate);


    /**
     * 更新企业钱包对账数据
     *
     * @return
     * @author llc
     * @date 2019-09-18
     */
    int updateHuifuWalletReconciliation(@Param("tradeDate") String tradeDate);


    /**
     * 清除临时企业钱包对账数据
     *
     * @return
     * @author llc
     * @date 2019-09-18
     */
    int deleteTempWalletReconciliation();


    /**
     * 企业钱包账户对账数据生成
     *
     * @author llc
     * @date 2019-09-19
     */
    List<Map<String, Object>> getWalletReconciliationList(HuifuWalletTradeDto dto);


    /**
     * 获取企业钱包账户对账统计数据
     *
     * @author llc
     * @date 2019-09-19
     */
    Map<String, Object> getWalletReconciliationSum(HuifuWalletTradeDto dto);
    List<Map<String, Object>> findReconciliationsByNo(@Param("tradeSerialNo") String tradeSerialNo);

}
