/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.zbkj.common.config.SmsConfig;
import com.zbkj.common.constants.NotifyConstants;
import com.zbkj.common.dto.HuaWeiSmsContent;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.sms.SmsTemplate;
import com.zbkj.common.model.system.SystemNotification;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.MessageUtil;
import com.zbkj.common.utils.PlaceHolderReplaceUtils;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.utils.RequestUtil;
import com.zbkj.common.utils.ValidateFormUtil;
import com.zbkj.service.service.SmsService;
import com.zbkj.service.service.SmsTemplateService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.SystemNotificationService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class HuaweiSmsServiceImpl
implements SmsService {
    private static final Logger logger = LoggerFactory.getLogger(HuaweiSmsServiceImpl.class);
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SmsTemplateService smsTemplateService;
    @Autowired
    private SystemNotificationService systemNotificationService;

    private void beforeSendMessage() {
    }

    @Override
    public Boolean sendCommonCode(String phone) {
        ValidateFormUtil.isPhone((String)phone, (String)"\u624b\u673a\u53f7\u7801\u9519\u8bef");
        DateTime dateTime = DateUtil.date();
        String clientIp = RequestUtil.getClientIp();
        this.beforeSendCommonCodeCheck(phone, clientIp, dateTime);
        String codeExpireStr = this.systemConfigService.getValueByKey("sms_code_expire");
        if (StrUtil.isBlank((CharSequence)codeExpireStr) || Integer.parseInt(codeExpireStr) == 0) {
            codeExpireStr = "5";
        }
        Integer code = CrmebUtil.randomCount((Integer)111111, (Integer)999999);
        Boolean success = false;
        if (SmsConfig.isSendSwitch().booleanValue()) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("\u672c\u6b21\u9a8c\u8bc1\u7801\uff1a" + code + " " + codeExpireStr + "\u5206\u949f\u540e\u8fc7\u671f");
            HuaWeiSmsContent huaWeiSmsContent = new HuaWeiSmsContent();
            huaWeiSmsContent.setMobile(phone);
            huaWeiSmsContent.setParams(JSONArray.toJSONString(params));
            huaWeiSmsContent.setSmsCode(SmsConfig.getCode());
            success = MessageUtil.sendHuaWeiSMS((HuaWeiSmsContent)huaWeiSmsContent);
            if (!success.booleanValue()) {
                throw new CrmebException("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u540e\u53f0\u7ba1\u7406\u5458");
            }
        } else {
            logger.info("SmsConfig.isSendSwitch\u77ed\u4fe1\u5f00\u5173\u6ca1\u6709\u6253\u5f00\uff0c\u672c\u6b21\u77ed\u4fe1\u53d1\u9001\u53d6\u6d88");
        }
        this.redisUtil.set("sms:validate:code:" + phone, (Object)code, Long.valueOf(codeExpireStr), TimeUnit.MINUTES);
        this.redisUtil.set("sms:validate:phone:" + phone, (Object)1, Long.valueOf(60L));
        return success;
    }

    private void beforeSendCommonCodeCheck(String phone, String clientIp, DateTime dateTime) {
        if (this.redisUtil.exists("sms:validate:phone:" + phone).booleanValue()) {
            throw new CrmebException("\u60a8\u7684\u77ed\u4fe1\u53d1\u9001\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
    }

    @Override
    public Boolean sendPaySuccess(String phone, String orderNo, BigDecimal payPrice) {
        SmsTemplate temp;
        try {
            this.beforeSendMessage();
            temp = this.getSmsTemp("paySuccess");
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff0c{}", (Object)e.getMessage());
            return false;
        }
        HashMap map = CollUtil.newHashMap();
        map.put("pay_price", payPrice);
        map.put("order_id", orderNo);
        String message = PlaceHolderReplaceUtils.replaceWithMap((String)temp.getContent(), (Map)map);
        return this.sendHuaweiSms(message, phone);
    }

    @Override
    public Boolean sendMessage(String phone, String message) {
        return this.sendHuaweiSms(message, phone);
    }

    public Boolean sendHuaweiSms(String message, String phone) {
        Boolean success = false;
        if (SmsConfig.isSendSwitch().booleanValue()) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(message);
            HuaWeiSmsContent huaWeiSmsContent = new HuaWeiSmsContent();
            huaWeiSmsContent.setMobile(phone);
            huaWeiSmsContent.setParams(JSONArray.toJSONString(params));
            huaWeiSmsContent.setSmsCode(SmsConfig.getCode());
            success = MessageUtil.sendHuaWeiSMS((HuaWeiSmsContent)huaWeiSmsContent);
            if (!success.booleanValue()) {
                throw new CrmebException("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u540e\u53f0\u7ba1\u7406\u5458");
            }
        } else {
            logger.info("SmsConfig.isSendSwitch\u77ed\u4fe1\u5f00\u5173\u6ca1\u6709\u6253\u5f00\uff0c\u672c\u6b21\u77ed\u4fe1\u53d1\u9001\u53d6\u6d88");
        }
        return success;
    }

    @Override
    public Boolean sendOrderDeliverNotice(String phone, String nickName, String storeName, String orderNo) {
        SmsTemplate temp;
        try {
            this.beforeSendMessage();
            temp = this.getSmsTemp("deliverGoods");
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff0c{}", (Object)e.getMessage());
            return false;
        }
        HashMap map = CollUtil.newHashMap();
        map.put("nickname", nickName);
        map.put("store_name", storeName);
        map.put("order_id", orderNo);
        String message = PlaceHolderReplaceUtils.replaceWithMap((String)temp.getContent(), (Map)map);
        return this.sendHuaweiSms(message, phone);
    }

    @Override
    public Boolean sendMerchantAuditSuccessNotice(String phone, String date, String merName, String merPhone, String pwd, String siteName) {
        SmsTemplate temp;
        try {
            this.beforeSendMessage();
            temp = this.getSmsTemp("auditSuccess");
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff0c{}", (Object)e.getMessage());
            return false;
        }
        HashMap map = CollUtil.newHashMap();
        map.put("date", date);
        map.put("mer", merName);
        map.put("phone", merPhone);
        map.put("pwd", pwd);
        map.put("site_name", siteName);
        String message = PlaceHolderReplaceUtils.replaceWithMap((String)temp.getContent(), (Map)map);
        return this.sendHuaweiSms(message, phone);
    }

    @Override
    public Boolean sendMerchantFileSuccessNotice(String phone, String date, String merName, String siteName) {
        SmsTemplate temp;
        try {
            this.beforeSendMessage();
            temp = this.getSmsTemp("auditFail");
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff0c{}", (Object)e.getMessage());
            return false;
        }
        HashMap map = CollUtil.newHashMap();
        map.put("date", date);
        map.put("mer", merName);
        map.put("site", siteName);
        String message = PlaceHolderReplaceUtils.replaceWithMap((String)temp.getContent(), (Map)map);
        return this.sendHuaweiSms(message, phone);
    }

    @Override
    public Boolean sendBirthdayPresent(String phone, String name) {
        SmsTemplate temp;
        try {
            this.beforeSendMessage();
            temp = this.getSmsTemp("birthdayPresent");
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff0c{}", (Object)e.getMessage());
            return false;
        }
        HashMap map = CollUtil.newHashMap();
        map.put("name", name);
        String message = PlaceHolderReplaceUtils.replaceWithMap((String)temp.getContent(), (Map)map);
        return this.sendHuaweiSms(message, phone);
    }

    private SmsTemplate getSmsTemp(String mark) {
        SystemNotification notification = this.systemNotificationService.getByMark(mark);
        if (ObjectUtil.isNull((Object)notification)) {
            throw new CrmebException("\u672a\u627e\u5230\u6d88\u606f\u901a\u77e5\u914d\u7f6e");
        }
        if (!notification.getIsSms().equals(NotifyConstants.SWITCH_OPEN)) {
            throw new CrmebException(notification.getDescription() + "\u672a\u914d\u7f6e\u77ed\u4fe1\u76f8\u5173\u6216\u5df2\u5173\u95ed");
        }
        SmsTemplate smsTemplate = this.smsTemplateService.getDetail(notification.getSmsId());
        return smsTemplate;
    }
}

