/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.bcx;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bcx.BcxOrderRelation;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.bcx.BcxOrderRelationResponse;
import com.zbkj.service.dao.bcx.BcxOrderRelationDao;
import com.zbkj.service.service.bcx.BcxOrderRelationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class BcxOrderRelationServiceImpl
extends ServiceImpl<BcxOrderRelationDao, BcxOrderRelation>
implements BcxOrderRelationService {
    @Resource
    private BcxOrderRelationDao dao;

    @Override
    public BcxOrderRelation queryById(Integer id) {
        return (BcxOrderRelation)this.dao.selectById(id);
    }

    @Override
    public List<BcxOrderRelationResponse> queryByOrderNo(String orderNo, Boolean isPlatOrderNo) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(BcxOrderRelation::getOrderNo, (Object)orderNo);
        BcxOrderRelation bcxOrderRelation = (BcxOrderRelation)this.dao.selectOne((Wrapper)lqw);
        if (bcxOrderRelation != null && StrUtil.isNotBlank((CharSequence)bcxOrderRelation.getMasterOrderNo())) {
            HashMap<String, Object> queryParam = new HashMap<String, Object>();
            queryParam.put("orderNo", orderNo);
            queryParam.put("masterOrderNo", bcxOrderRelation.getMasterOrderNo());
            queryParam.put("isPlatOrderNo", isPlatOrderNo);
            return this.dao.queryByMasterOrderNo(queryParam);
        }
        return CollUtil.newArrayList((Object[])new BcxOrderRelationResponse[0]);
    }

    @Override
    public PageInfo<BcxOrderRelation> queryPagedList(BcxOrderRelation request, PageParamRequest pageParamRequest) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(BcxOrderRelation::getId, (Object)request.getId());
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List sources = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)sources)) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new BcxOrderRelation[0]));
        }
        List<BcxOrderRelation> result = this.transform2target(sources);
        return CommonPage.copyPageInfo((Page)page, result);
    }

    private List<BcxOrderRelation> transform2target(List<BcxOrderRelation> sources) {
        ArrayList<BcxOrderRelation> result = new ArrayList<BcxOrderRelation>();
        for (BcxOrderRelation source : sources) {
            BcxOrderRelation target = new BcxOrderRelation();
            BeanUtils.copyProperties((Object)source, (Object)target);
            result.add(target);
        }
        return result;
    }

    @Override
    public Boolean create(BcxOrderRelation bcxOrderRelation) {
        return this.save(bcxOrderRelation);
    }

    @Override
    public Boolean update(BcxOrderRelation bcxOrderRelation) {
        return this.updateById(bcxOrderRelation);
    }

    @Override
    public Boolean delete(Integer id) {
        return this.removeById(id);
    }
}

