/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.huifu.v2;

import cn.hutool.extra.servlet.ServletUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huifu.bspay.sdk.opps.core.request.V2TradePaymentJspayRequest;
import com.huifu.bspay.sdk.opps.core.utils.DateTools;
import com.huifu.bspay.sdk.opps.core.utils.SequenceTools;
import com.zbkj.common.dto.AlipayData;
import com.zbkj.common.dto.Detail;
import com.zbkj.common.dto.GoodsDetail;
import com.zbkj.common.dto.WxData;
import com.zbkj.common.utils.DateUtils;
import com.zbkj.common.utils.RequestUtil;
import com.zbkj.service.huifu.core.Identify;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

@Identify(requestClass=V2TradePaymentJspayRequest.class)
public class V2TradePaymentJspay {
    public static V2TradePaymentJspayRequest method(Map<String, Object> map) {
        V2TradePaymentJspayRequest request = (V2TradePaymentJspayRequest)JSONObject.parseObject((String)JSON.toJSONString(map), V2TradePaymentJspayRequest.class);
        request.setReqDate(DateTools.getCurrentDateYYYYMMDD());
        request.setReqSeqId(SequenceTools.getReqSeqId32());
        request.setTradeType("T_MINIAPP");
        Map<String, Object> extendInfoMap = V2TradePaymentJspay.getExtendInfos(map);
        request.setExtendInfo(extendInfoMap);
        return request;
    }

    private static Map<String, Object> getExtendInfos(Map<String, Object> map) {
        HashMap<String, Object> extendInfoMap = new HashMap<String, Object>();
        extendInfoMap.put("time_expire", DateUtils.formatDate((Date)DateUtils.addMinutes((Date)new Date(), (int)5), (Object[])new Object[]{"yyyyMMddHHmmss"}));
        extendInfoMap.put("limit_pay_type", "NO_CREDIT");
        extendInfoMap.put("delay_acct_flag", "N");
        extendInfoMap.put("channel_no", "");
        extendInfoMap.put("pay_scene", "01");
        extendInfoMap.put("risk_check_data", V2TradePaymentJspay.getRiskCheckData());
        extendInfoMap.put("acct_split_bunch", V2TradePaymentJspay.getAcctSplitBunch(map));
        extendInfoMap.put("term_div_coupon_type", "0");
        extendInfoMap.put("wx_data", V2TradePaymentJspay.getWxData(map));
        extendInfoMap.put("alipay_data", V2TradePaymentJspay.getAlipayData(map));
        extendInfoMap.put("fq_mer_discount_flag", "N");
        extendInfoMap.put("notify_url", map.get("notifyUrl"));
        extendInfoMap.put("remark", map.get("remark"));
        extendInfoMap.put("acct_id", "");
        return extendInfoMap;
    }

    private static String getCombinedpayData() {
        JSONObject dto = new JSONObject();
        JSONArray dtoList = new JSONArray();
        dtoList.add((Object)dto);
        return dtoList.toJSONString();
    }

    private static String getRiskCheckData() {
        String clientIP = "127.0.0.1";
        try {
            HttpServletRequest request = RequestUtil.getRequest();
            clientIP = ServletUtil.getClientIP((HttpServletRequest)request, null);
        }
        catch (Exception request) {
            // empty catch block
        }
        JSONObject dto = new JSONObject();
        dto.put("ip_addr", (Object)clientIP);
        dto.put("base_station", (Object)"");
        dto.put("latitude", (Object)"");
        dto.put("longitude", (Object)"");
        return dto.toJSONString();
    }

    private static String getTerminalDeviceData() {
        JSONObject dto = new JSONObject();
        dto.put("devs_id", (Object)"SPINTP357338300264411");
        dto.put("device_type", (Object)"1");
        dto.put("device_ip", (Object)"10.10.0.1");
        dto.put("device_mac", (Object)"");
        dto.put("device_imei", (Object)"");
        dto.put("device_imsi", (Object)"");
        dto.put("device_icc_id", (Object)"");
        dto.put("device_wifi_mac", (Object)"");
        dto.put("device_gps", (Object)"192.168.0.0");
        return dto.toJSONString();
    }

    private static JSON getAcctInfosRucan(Map<String, Object> map) {
        JSONArray dtoList = new JSONArray();
        JSONObject dto = new JSONObject();
        dto.put("div_amt", map.get("commissionAmount"));
        dto.put("huifu_id", map.get("huifuId"));
        dtoList.add((Object)dto);
        JSONObject dto1 = new JSONObject();
        dto1.put("div_amt", map.get("inAmount"));
        dto1.put("huifu_id", map.get("inWalletAccountNo"));
        dtoList.add((Object)dto1);
        return dtoList;
    }

    private static String getAcctSplitBunch(Map<String, Object> map) {
        JSONObject dto = new JSONObject();
        dto.put("acct_infos", (Object)V2TradePaymentJspay.getAcctInfosRucan(map));
        return dto.toJSONString();
    }

    private static JSON getGoodsDetailWxRucan(List<GoodsDetail> goods_detail) {
        JSONArray dtoList = new JSONArray();
        for (GoodsDetail detail : goods_detail) {
            JSONObject dto = new JSONObject();
            dto.put("goods_id", (Object)detail.getGoods_id());
            dto.put("goods_name", (Object)detail.getGoods_name());
            dto.put("price", (Object)detail.getPrice());
            dto.put("quantity", (Object)detail.getQuantity());
            dtoList.add((Object)dto);
        }
        return dtoList;
    }

    private static JSON getDetail(Detail detail) {
        JSONObject dto = new JSONObject();
        dto.put("goods_detail", (Object)V2TradePaymentJspay.getGoodsDetailWxRucan(detail.getGoods_detail()));
        dto.put("cost_price", (Object)detail.getCost_price());
        return dto;
    }

    private static JSON getStoreInfo() {
        JSONObject dto = new JSONObject();
        JSONArray dtoList = new JSONArray();
        dtoList.add((Object)dto);
        return dtoList;
    }

    private static JSON getSceneInfo() {
        JSONObject dto = new JSONObject();
        return dto;
    }

    private static String getWxData(Map<String, Object> map) {
        WxData wxData = StringUtils.isNotEmpty((CharSequence)(map.get("wxData") + "")) ? (WxData)JSONObject.parseObject((String)(map.get("wxData") + ""), WxData.class) : null;
        JSONObject dto = new JSONObject();
        dto.put("sub_appid", (Object)wxData.getSub_appid());
        dto.put("openid", (Object)wxData.getOpenid());
        dto.put("sub_openid", (Object)wxData.getSub_openid());
        dto.put("attach", (Object)"");
        dto.put("body", (Object)wxData.getBody());
        dto.put("detail", (Object)V2TradePaymentJspay.getDetail(wxData.getDetail()));
        return dto.toJSONString();
    }

    private static JSON getExtendParams() {
        JSONObject dto = new JSONObject();
        dto.put("card_type", (Object)"");
        dto.put("food_order_type", (Object)"qr_order");
        dto.put("hb_fq_num", (Object)"");
        dto.put("hb_fq_seller_percent", (Object)"");
        dto.put("industry_reflux_info", (Object)"string");
        dto.put("parking_id", (Object)"123wsx");
        dto.put("sys_service_provider_id", (Object)"1111111");
        return dto;
    }

    private static JSON getGoodsDetail(List<GoodsDetail> goods_detail) {
        JSONArray dtoList = new JSONArray();
        for (GoodsDetail detail : goods_detail) {
            JSONObject dto = new JSONObject();
            dto.put("goods_id", (Object)detail.getGoods_id());
            dto.put("goods_name", (Object)detail.getGoods_name());
            dto.put("price", (Object)detail.getPrice());
            dto.put("quantity", (Object)detail.getQuantity());
            dto.put("body", (Object)"");
            dto.put("categories_tree", (Object)"");
            dto.put("goods_category", (Object)"");
            dto.put("show_url", (Object)"");
            dtoList.add((Object)dto);
        }
        return dtoList;
    }

    private static String getAlipayData(Map<String, Object> map) {
        AlipayData alipayData = StringUtils.isNotEmpty((CharSequence)(map.get("alipayData") + "")) ? (AlipayData)JSONObject.parseObject((String)(map.get("alipayData") + ""), AlipayData.class) : null;
        JSONObject dto = new JSONObject();
        if (alipayData != null) {
            dto.put("buyer_id", (Object)"");
            dto.put("alipay_store_id", (Object)"");
            dto.put("buyer_logon_id", (Object)alipayData.getBuyer_logon_id());
            dto.put("goods_detail", (Object)V2TradePaymentJspay.getGoodsDetail(alipayData.getGoods_detail()));
            dto.put("merchant_order_no", (Object)"");
            dto.put("operator_id", (Object)"");
            dto.put("product_code", (Object)"");
            dto.put("seller_id", (Object)"");
            dto.put("store_id", (Object)"");
        }
        return dto.toJSONString();
    }

    private static JSON getPayeeInfo() {
        JSONObject dto = new JSONObject();
        return dto;
    }

    private static String getUnionpayData() {
        JSONObject dto = new JSONObject();
        return dto.toJSONString();
    }

    private static String getDcData() {
        JSONObject dto = new JSONObject();
        return dto.toJSONString();
    }
}

