/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.wangshang.notify.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zbkj.common.model.huifu.HuifuWalletReconciliation;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.dao.HuifuWalletReconciliationDao;
import com.zbkj.service.service.TransactionLogService;
import com.zbkj.service.wangshang.api.domain.RequestHead;
import com.zbkj.service.wangshang.api.domain.model.notify.BkcloudfundsElectronicReceiptNotifyModel;
import com.zbkj.service.wangshang.api.internal.parser.xml.XmlConverter;
import com.zbkj.service.wangshang.api.service.notify.BkcloudfundsElectronicReceiptNotifyRequest;
import com.zbkj.service.wangshang.handle.CommomRequstHandle;
import com.zbkj.service.wangshang.notify.service.MybankNotifyService;
import com.zbkj.service.wangshang.notify.service.impl.BkcloudfundsProtocolWithholdResultNotifyServiceImpl;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bkcloudfundsElectronicReceiptNotifyService")
public class BkcloudfundsElectronicReceiptNotifyServiceImpl
implements MybankNotifyService {
    private static final Logger logger = LoggerFactory.getLogger(BkcloudfundsProtocolWithholdResultNotifyServiceImpl.class);
    @Autowired
    private CommomRequstHandle commomRequstHandle;
    @Resource
    private HuifuWalletReconciliationDao huifuWalletReconciliationDao;
    @Autowired
    TransactionLogService transactionLogService;

    @Override
    public String notifyHandle(String context, String function) throws Exception {
        logger.info("========= > \u7535\u5b50\u4e1a\u52a1\u51ed\u8bc1\u7533\u8bf7\u7ed3\u679c\u901a\u77e5:ant.mybank.bkcloudfunds.electronicreceipt.notify");
        logger.info("========= > \u8bf7\u6c42\u62a5\u6587\uff1a" + context);
        BkcloudfundsElectronicReceiptNotifyRequest electronicReceiptNotifyRequest = XmlConverter.getInstance().toResponse(context, BkcloudfundsElectronicReceiptNotifyRequest.class);
        RequestHead head = electronicReceiptNotifyRequest.getBkcloudfundsElectronicReceiptNotify().getRequestHead();
        boolean flag = this.saveNotify(electronicReceiptNotifyRequest.getBkcloudfundsElectronicReceiptNotify().getBkcloudfundsElectronicReceiptNotifyModel());
        String response = this.commomRequstHandle.getSignResult(flag, head);
        this.transactionLogService.save("\u7535\u5b50\u4e1a\u52a1\u51ed\u8bc1\u7533\u8bf7\u7ed3\u679c\u901a\u77e5:ant.mybank.bkcloudfunds.electronicreceipt.notify", "1", context, response, PaymentChannel.WANGSHANG.toString());
        return response;
    }

    private boolean saveNotify(BkcloudfundsElectronicReceiptNotifyModel model) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(HuifuWalletReconciliation::getReceiptNo, (Object)model.getReceiptNo());
        List list = this.huifuWalletReconciliationDao.selectList((Wrapper)lqw);
        if (list.size() > 0) {
            HuifuWalletReconciliation re = (HuifuWalletReconciliation)list.get(0);
            if (model.getStatus().equals(re.getReceiptStatus())) {
                return true;
            }
            re.setReceiptStatus(model.getStatus());
            re.setUpdateTime(new Date());
            this.huifuWalletReconciliationDao.updateById(re);
            return true;
        }
        return false;
    }
}

