/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.bcx.cores.configs;

import com.alibaba.fastjson.JSON;
import com.zbkj.bcx.cores.components.JsonProvider;
import com.zbkj.bcx.cores.components.RetryProvider;
import com.zbkj.bcx.cores.exceptions.IgnoreCoreException;
import java.util.HashMap;
import java.util.function.Supplier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.policy.ExceptionClassifierRetryPolicy;
import org.springframework.retry.policy.NeverRetryPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;

@Configuration
public class BcxCoreConfig {
    @Bean
    public RetryTemplate retryTemplate() {
        RetryTemplate retryTemplate = new RetryTemplate();
        FixedBackOffPolicy fixedBackOffPolicy = new FixedBackOffPolicy();
        fixedBackOffPolicy.setBackOffPeriod(200L);
        retryTemplate.setBackOffPolicy((BackOffPolicy)fixedBackOffPolicy);
        ExceptionClassifierRetryPolicy retryPolicy = new ExceptionClassifierRetryPolicy();
        HashMap<Class, Object> policyMap = new HashMap<Class, Object>();
        policyMap.put(IgnoreCoreException.class, new NeverRetryPolicy());
        policyMap.put(Exception.class, new SimpleRetryPolicy(5));
        retryPolicy.setPolicyMap(policyMap);
        retryTemplate.setRetryPolicy((RetryPolicy)retryPolicy);
        return retryTemplate;
    }

    @Bean
    public RetryProvider retryProvider(final RetryTemplate retryTemplate) {
        return new RetryProvider(){

            @Override
            public <T> T doExecute(Supplier<T> supplier) {
                return (T)retryTemplate.execute(vr -> supplier.get());
            }
        };
    }

    @Bean
    public JsonProvider jsonProvider() {
        return new JsonProvider(){

            @Override
            public <T> String toJson(T data) {
                return JSON.toJSONString(data);
            }

            @Override
            public <T> T toObject(String data, Class<T> tClass) {
                return (T)JSON.parseObject((String)data, tClass);
            }
        };
    }
}

