/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.utils;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    private static String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM", "yyyyMMddHHmmss", "yyyyMMdd", "yyyyMM", "yyyy\u5e74MM\u6708dd\u65e5", "HH:mm"};

    public static String getDate() {
        return DateUtils.getDate("yyyy-MM-dd");
    }

    public static String getDate(String pattern) {
        return DateFormatUtils.format((Date)new Date(), (String)pattern);
    }

    public static String formatDate(Date date, Object ... pattern) {
        String formatDate = null;
        formatDate = pattern != null && pattern.length > 0 ? DateFormatUtils.format((Date)date, (String)pattern[0].toString()) : DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd");
        return formatDate;
    }

    public static String formatDateTime(Date date) {
        return DateUtils.formatDate(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String formatTime(Date date) {
        return DateUtils.formatDate(date, "HH:mm:ss");
    }

    public static String getTime() {
        return DateUtils.formatDate(new Date(), "HH:mm:ss");
    }

    public static String getDateTime() {
        return DateUtils.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss");
    }

    public static String getYear() {
        return DateUtils.formatDate(new Date(), "yyyy");
    }

    public static String getMonth() {
        return DateUtils.formatDate(new Date(), "MM");
    }

    public static String getDay() {
        return DateUtils.formatDate(new Date(), "dd");
    }

    public static String getWeek() {
        return DateUtils.formatDate(new Date(), "E");
    }

    public static Date parseDate(Object str) {
        if (str == null) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str.toString(), (String[])parsePatterns);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getTomorrow() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        c.add(5, 1);
        return df.format(c.getTime());
    }

    public static long pastDays(Date date) {
        long t = System.currentTimeMillis() - date.getTime();
        return t / 86400000L;
    }

    public static long pastHour(Date date) {
        long t = System.currentTimeMillis() - date.getTime();
        return t / 3600000L;
    }

    public static long pastMinutes(Date date) {
        long t = System.currentTimeMillis() - date.getTime();
        return t / 60000L;
    }

    public static String formatDateTime(long timeMillis) {
        long day = timeMillis / 86400000L;
        long hour = timeMillis / 3600000L - day * 24L;
        long min = timeMillis / 60000L - day * 24L * 60L - hour * 60L;
        long s = timeMillis / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        long sss = timeMillis - day * 24L * 60L * 60L * 1000L - hour * 60L * 60L * 1000L - min * 60L * 1000L - s * 1000L;
        return (day > 0L ? day + "," : "") + hour + ":" + min + ":" + s + "." + sss;
    }

    public static String stampToDate(long timeMillis) {
        return DateUtils.formatDateTime(new Date(timeMillis));
    }

    public static double getDistanceOfTwoDate(Date before, Date after) {
        long beforeTime = before.getTime();
        long afterTime = after.getTime();
        return (afterTime - beforeTime) / 86400000L + 1L;
    }

    public static String getDayOfTwoDate(Date before, Date after) {
        long beforeTime = before.getTime();
        long afterTime = after.getTime();
        int day = (int)((afterTime - beforeTime) / 86400000L + 1L);
        int year = day / 365;
        int month = day % 365 / 30;
        int days = day % 365 % 30;
        String yearStr = year > 0 ? year + "\u5e74" : "";
        String monthStr = month > 0 ? month + "\u6708" : "";
        String daysStr = days > 0 ? days + "\u5929" : "";
        String limitTime = yearStr + monthStr + daysStr;
        return limitTime;
    }

    public static List<String> getDatesByMonth(String month) {
        DateTime date = new DateTime((Object)(month + "-01"));
        ImmutableList.Builder dayList = ImmutableList.builder();
        LocalDate firstDay = date.toLocalDate().withDayOfMonth(1);
        LocalDate nextMonthFirstDay = firstDay.plusMonths(1);
        while (firstDay.isBefore((ReadablePartial)nextMonthFirstDay)) {
            dayList.add((Object)firstDay.toDateTimeAtStartOfDay().getMillis());
            firstDay = firstDay.plusDays(1);
        }
        ImmutableList dates = dayList.build();
        ArrayList dateList = Lists.newArrayList();
        dates.forEach(t -> dateList.add(new SimpleDateFormat("yyyy-MM-dd").format(new Date((long)t))));
        return dateList;
    }

    public static String dateAdd(String type, String sdate, String format, int num) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat(format);
        Date date = df.parse(sdate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if ("y".equals(type)) {
            cal.add(1, num);
        } else if ("m".equals(type)) {
            cal.add(2, num);
        } else if ("h".equals(type)) {
            cal.add(10, num);
        } else if ("i".equals(type)) {
            cal.add(12, num);
        } else if ("s".equals(type)) {
            cal.add(13, num);
        } else {
            cal.add(5, num);
        }
        return df.format(cal.getTime());
    }

    public static List<String> getBetweenDatesByDate(Date startDate, Date endDate) {
        ArrayList dateList = Lists.newArrayList();
        long days = DateUtil.betweenDay((Date)startDate, (Date)endDate, (boolean)false);
        dateList.add(DateUtil.formatDate((Date)startDate));
        int i = 1;
        while ((long)i <= days) {
            cn.hutool.core.date.DateTime nextDate = DateUtil.offsetDay((Date)startDate, (int)i);
            dateList.add(DateUtil.formatDate((Date)nextDate));
            ++i;
        }
        return dateList;
    }

    public static String getWeek(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEEE");
        String week = sdf.format(date);
        return week;
    }

    public static int getWeekInt(Date date) {
        int weekInt = 0;
        SimpleDateFormat sdf = new SimpleDateFormat("EEEE");
        String week = sdf.format(date);
        if ("\u661f\u671f\u4e00".equals(week)) {
            weekInt = 1;
        }
        if ("\u661f\u671f\u4e8c".equals(week)) {
            weekInt = 2;
        }
        if ("\u661f\u671f\u4e09".equals(week)) {
            weekInt = 3;
        }
        if ("\u661f\u671f\u56db".equals(week)) {
            weekInt = 4;
        }
        if ("\u661f\u671f\u4e94".equals(week)) {
            weekInt = 5;
        }
        if ("\u661f\u671f\u516d".equals(week)) {
            weekInt = 6;
        }
        if ("\u661f\u671f\u65e5".equals(week)) {
            weekInt = 7;
        }
        return weekInt;
    }

    public static int getDayNumAfterOneMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, 1);
        Date dayAfter = cal.getTime();
        double dayNum = DateUtils.getDistanceOfTwoDate(date, dayAfter);
        return (int)dayNum;
    }

    public static Date getDayAfterOneMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, 1);
        Date dayAfter = cal.getTime();
        return dayAfter;
    }

    public static String getDayAfterSomeDay(Date date, int i) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, i);
        Date dayAfter = cal.getTime();
        return DateUtils.formatDate(dayAfter, new Object[0]);
    }

    public static Date getDayAfterSomeMinute(Date date, int i) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(12, i);
        return cal.getTime();
    }

    public static String hourDiff(Date smdate, Date bdate) {
        String hour = "";
        String minute = "";
        if (smdate == null || bdate == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            smdate = sdf.parse(sdf.format(smdate));
            bdate = sdf.parse(sdf.format(bdate));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        double time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        double time2 = cal.getTimeInMillis();
        double between_hour = (time2 - time1) / 3600000.0;
        double between_minu = (time2 - time1) / 60000.0;
        hour = between_hour >= 1.0 ? (int)between_hour + "\u5c0f\u65f6" : "";
        if (between_minu % 60.0 > 0.0) {
            minute = (int)between_minu % 60 + "\u5206\u949f";
        }
        return hour + minute;
    }

    public static Double minDiff(Date smdate, Date bdate) {
        String hour = "";
        String minute = "";
        if (smdate == null || bdate == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            smdate = sdf.parse(sdf.format(smdate));
            bdate = sdf.parse(sdf.format(bdate));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        double time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        double time2 = cal.getTimeInMillis();
        double between_minu = (time2 - time1) / 60000.0;
        return between_minu;
    }

    public static Double minDiff(String smallDate, String bigDate) {
        Date smdate = DateUtils.parseDate(smallDate);
        Date bdate = DateUtils.parseDate(bigDate);
        String hour = "";
        String minute = "";
        if (smdate == null || bdate == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            smdate = sdf.parse(sdf.format(smdate));
            bdate = sdf.parse(sdf.format(bdate));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        double time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        double time2 = cal.getTimeInMillis();
        double between_minu = (time2 - time1) / 60000.0;
        return between_minu;
    }

    public static long getDateSubDateToMinutes(Date date1, Date date2) {
        long minute = 0L;
        try {
            if (date1 != null && date2 != null) {
                long long1 = date1.getTime();
                long long2 = date2.getTime();
                minute = (long2 - long1) / 1000L / 60L;
            }
        }
        catch (Exception e) {
            System.err.println("\u8ba1\u7b97date2\u51cf\u53bbdate1\u6240\u5f97\u7684\u79d2\u6570\u5931\u8d25!");
        }
        return minute;
    }

    public static long getDateSubDateToSeconds(Date date1, Date date2) {
        long second = 0L;
        try {
            if (date1 != null && date2 != null) {
                long long1 = date1.getTime();
                long long2 = date2.getTime();
                second = (long2 - long1) / 1000L;
            }
        }
        catch (Exception e) {
            System.err.println("\u8ba1\u7b97date2\u51cf\u53bbdate1\u6240\u5f97\u7684\u79d2\u6570\u5931\u8d25!");
        }
        return second;
    }

    public static String getDayHourMinute(Long totalMinutes) {
        Long day = totalMinutes / 1440L;
        Long hour = totalMinutes % 1440L / 60L;
        Long minute = totalMinutes % 1440L % 60L;
        String content = "";
        if (day > 0L) {
            content = content + day + "\u5929";
        }
        if (hour > 0L) {
            content = content + hour + "\u5c0f\u65f6";
        }
        if (minute > 0L) {
            content = content + minute + "\u5206\u949f";
        }
        return content;
    }

    public static int getDaysByYearMonth(int year, int month) {
        Calendar a = Calendar.getInstance();
        a.set(1, year);
        a.set(2, month - 1);
        a.set(5, 1);
        a.roll(5, -1);
        int maxDate = a.get(5);
        return maxDate;
    }

    public static boolean checkDate(String sourceDate) {
        if (sourceDate == null) {
            return false;
        }
        if (sourceDate.length() - sourceDate.replaceAll("-", "").length() != 2) {
            return false;
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            dateFormat.setLenient(false);
            dateFormat.parse(sourceDate);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean checkTime(String sourceTime) {
        if (sourceTime == null) {
            return false;
        }
        if (sourceTime.length() - sourceTime.replaceAll("-", "").length() != 2) {
            return false;
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateFormat.setLenient(false);
            dateFormat.parse(sourceTime);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean dateCompare(String strDate1, String strDate2) {
        boolean flag = false;
        if (strDate1 == null || strDate2 == null) {
            return flag;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date1 = dateFormat.parse(strDate1);
            Date date2 = dateFormat.parse(strDate2);
            flag = date1.getTime() <= date2.getTime();
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    public static String calculationTimes(Date startTime, Date endTime) {
        long longWaitTime = DateUtil.between((Date)startTime, (Date)endTime, (DateUnit)DateUnit.SECOND);
        String timeDiff = DateUtil.secondToTime((int)Integer.parseInt(String.valueOf(longWaitTime)));
        String[] timeArr = timeDiff.split(":");
        ArrayList<Integer> timeList = new ArrayList<Integer>();
        for (String time : timeArr) {
            if (time.equalsIgnoreCase("00")) {
                time = "0";
            }
            timeList.add(Integer.parseInt(time));
        }
        String waitTime = "\u5df2\u7b49\u5f85";
        waitTime = (Integer)timeList.get(0) == 0 ? waitTime + timeList.get(1) + "\u5206\u949f" + timeList.get(2) + "\u79d2" : ((Integer)timeList.get(0) >= 24 ? waitTime + (Integer)timeList.get(0) / 24 + "\u5929" + (Integer)timeList.get(0) % 24 + "\u5c0f\u65f6" + timeList.get(1) + "\u5206\u949f" + timeList.get(2) + "\u79d2" : waitTime + timeList.get(0) + "\u5c0f\u65f6" + timeList.get(1) + "\u5206\u949f" + timeList.get(2) + "\u79d2");
        return waitTime;
    }

    public static String getNextDay(String dates) {
        Calendar c = Calendar.getInstance();
        Date date = null;
        try {
            date = new SimpleDateFormat("yy-MM-dd").parse(dates);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        c.setTime(date);
        int day = c.get(5);
        c.set(5, day + 1);
        String dayAfter = new SimpleDateFormat("yyyy-MM-dd").format(c.getTime());
        return dayAfter;
    }

    public static int dayOfWeek(String date) {
        int weekDaty = DateUtil.dayOfWeek((Date)DateUtil.parseDate((String)date)) == 1 ? 7 : DateUtil.dayOfWeek((Date)DateUtil.parseDate((String)date)) - 1;
        return weekDaty;
    }

    public static String getSpecifiedDayBefore(String specifiedDay, int days) {
        Calendar c = Calendar.getInstance();
        Date date = null;
        try {
            date = new SimpleDateFormat("yy-MM-dd").parse(specifiedDay);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        c.setTime(date);
        int day = c.get(5);
        c.set(5, day - days);
        String dayBefore = new SimpleDateFormat("yyyy-MM-dd").format(c.getTime());
        return dayBefore;
    }

    public static List<Date> getBetweenDates(Date start, Date end) {
        ArrayList<Date> result = new ArrayList<Date>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        while (tempStart.before(tempEnd)) {
            result.add(tempStart.getTime());
            tempStart.add(6, 1);
        }
        return result;
    }

    public static List<String> getDayListOfMonth(String paramMonth) {
        ArrayList<String> list = new ArrayList<String>();
        Calendar aCalendar = Calendar.getInstance(Locale.CHINA);
        aCalendar.setTime((Date)DateUtil.parse((String)paramMonth, (String)"yyyy-MM"));
        int year = aCalendar.get(1);
        int month = aCalendar.get(2) + 1;
        int day = aCalendar.getActualMaximum(5);
        for (int i = 1; i <= day; ++i) {
            String aDate = String.valueOf(year) + "/" + month + "/" + i;
            list.add(aDate);
        }
        return list;
    }

    public static String getBeforeTime(String dateStr, int n) {
        Calendar c = Calendar.getInstance();
        Date beforeTime = null;
        try {
            beforeTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        c.setTime(beforeTime);
        c.add(12, n);
        String dayBefore = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(c.getTime());
        return dayBefore;
    }

    public static void main(String[] args) throws ParseException {
        System.out.println(DateUtils.formatDate(new Date(), "HHmmss"));
        String monthfirstDay = "2020-04-01";
        String monthLastDay = DateUtils.formatDate((Date)DateUtil.endOfMonth((Date)DateUtils.parseDate(monthfirstDay)), new Object[0]);
        System.out.println(DateUtils.checkTime("2020-01-21 14:12:61"));
        System.out.println(DateUtils.dateCompare("2020-02-19", DateUtils.getDate()));
    }
}

