/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.bcx;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.bcx.BcxUserOrgAuth;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.bcx.BcxUserOrgAuthRequest;
import com.zbkj.service.dao.bcx.BcxUserOrgAuthDao;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.bcx.BcxUserOrgAuthService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class BcxUserOrgAuthServiceImpl
extends ServiceImpl<BcxUserOrgAuthDao, BcxUserOrgAuth>
implements BcxUserOrgAuthService {
    @Resource
    private BcxUserOrgAuthDao dao;
    @Resource
    private UserService userService;

    @Override
    public BcxUserOrgAuth queryById(Integer id) {
        return (BcxUserOrgAuth)this.dao.selectById(id);
    }

    @Override
    public PageInfo<BcxUserOrgAuth> queryPagedList(BcxUserOrgAuth request, PageParamRequest pageParamRequest) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(BcxUserOrgAuth::getId, (Object)request.getId());
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List sources = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)sources)) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new BcxUserOrgAuth[0]));
        }
        List<BcxUserOrgAuth> result = this.transform2target(sources);
        return CommonPage.copyPageInfo((Page)page, result);
    }

    private List<BcxUserOrgAuth> transform2target(List<BcxUserOrgAuth> sources) {
        ArrayList<BcxUserOrgAuth> result = new ArrayList<BcxUserOrgAuth>();
        for (BcxUserOrgAuth source : sources) {
            BcxUserOrgAuth target = new BcxUserOrgAuth();
            BeanUtils.copyProperties((Object)source, (Object)target);
            result.add(target);
        }
        return result;
    }

    @Override
    public Boolean create(BcxUserOrgAuthRequest bcxUserOrgAuth) {
        Integer userId = this.userService.getUserId();
        BcxUserOrgAuth exist = this.queryByUserId(userId);
        if (exist != null) {
            throw new CrmebException("\u5df2\u6709\u8ba4\u8bc1\u4f01\u4e1a\uff0c\u672c\u6b21\u8ba4\u8bc1\u53d6\u6d88");
        }
        this.userService.checkValidateCode(bcxUserOrgAuth.getPhone(), bcxUserOrgAuth.getAuthCode());
        bcxUserOrgAuth.setUid(userId);
        BcxUserOrgAuth org = new BcxUserOrgAuth();
        BeanUtils.copyProperties((Object)bcxUserOrgAuth, (Object)org);
        return this.save(org);
    }

    @Override
    public Boolean update(BcxUserOrgAuth bcxUserOrgAuth) {
        return this.updateById(bcxUserOrgAuth);
    }

    @Override
    public Boolean delete(Integer id) {
        return this.removeById(id);
    }

    @Override
    public BcxUserOrgAuth queryUserOrg() {
        Integer userId = this.userService.getUserIdException();
        return this.queryByUserId(userId);
    }

    private BcxUserOrgAuth queryByUserId(Integer userId) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(BcxUserOrgAuth::getUid, (Object)userId);
        return (BcxUserOrgAuth)this.dao.selectOne((Wrapper)lqw);
    }
}

