/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.utils;

import com.zbkj.common.utils.RedisUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedisLockUtil {
    private static final ConcurrentHashMap<String, ScheduledFuture> futureMap = new ConcurrentHashMap();
    protected long internalLockLeaseTime = 10L;
    protected long lockListenTime = this.internalLockLeaseTime + 1L;
    ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(4);
    @Autowired
    private RedisUtil redisUtil;
    private String lock_value = "pasp_lock_value";
    private long timeout = 5L;

    protected void scheduleExpirationRenewal(String key) {
        ScheduledFuture<?> future = this.executorService.schedule(new ExpirationRenewal(key), this.lockListenTime, TimeUnit.SECONDS);
        futureMap.put(key, future);
    }

    public boolean lock(String id) {
        Long start = System.currentTimeMillis();
        while (true) {
            boolean lock;
            if (lock = this.redisUtil.setNx(id, this.lock_value, this.internalLockLeaseTime)) {
                this.scheduleExpirationRenewal(id);
                return lock;
            }
            long l = System.currentTimeMillis() - start;
            if (l >= this.timeout) {
                return false;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void unlock(String id) {
        this.redisUtil.delete(id);
        ScheduledFuture future = futureMap.get(id);
        if (future != null) {
            future.cancel(false);
        }
    }

    public RedisUtil getRedisUtil() {
        return this.redisUtil;
    }

    private class ExpirationRenewal
    implements Runnable {
        private String key;

        public ExpirationRenewal(String key) {
            this.key = key;
        }

        @Override
        public void run() {
            if (RedisLockUtil.this.redisUtil.exists(this.key).booleanValue()) {
                System.out.println("\u6267\u884c\u5ef6\u8fdf\u5931\u6548\u65f6\u95f4\u4e2d...");
                RedisLockUtil.this.redisUtil.expire(this.key, RedisLockUtil.this.internalLockLeaseTime);
            }
        }
    }
}

