/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.infrastructure.offices.utils;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;

public class EmployeeCellWriteHandler
implements CellWriteHandler {
    private Integer authIndex;
    private Integer checkIndex;
    private Map<String, CellStyle> colorStyleMap;

    private CellStyle getCellStyle(String key) {
        return this.colorStyleMap.get(key);
    }

    private void setColorStyleMap(Workbook workbook) {
        if (this.colorStyleMap == null) {
            this.colorStyleMap = new HashMap<String, CellStyle>();
            CellStyle redCellStyle = workbook.createCellStyle();
            Font redFont = workbook.createFont();
            redFont.setColor((short)10);
            redCellStyle.setFont(redFont);
            this.colorStyleMap.put("\u672a\u63d0\u4ea4", redCellStyle);
            this.colorStyleMap.put("\u8ba4\u8bc1\u5931\u8d25", redCellStyle);
            CellStyle yellowCellStyle = workbook.createCellStyle();
            Font yellowFont = workbook.createFont();
            yellowFont.setColor(IndexedColors.ORANGE.index);
            yellowCellStyle.setFont(yellowFont);
            this.colorStyleMap.put("\u5df2\u63d0\u4ea4", yellowCellStyle);
            this.colorStyleMap.put("\u8ba4\u8bc1\u4e2d", yellowCellStyle);
            CellStyle greenCellStyle = workbook.createCellStyle();
            Font greenFont = workbook.createFont();
            greenFont.setColor(IndexedColors.GREEN.index);
            greenCellStyle.setFont(greenFont);
            this.colorStyleMap.put("\u5df2\u6838\u9a8c", greenCellStyle);
            this.colorStyleMap.put("\u5df2\u8ba4\u8bc1", greenCellStyle);
        }
    }

    public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<WriteCellData<?>> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        this.setColorStyleMap(writeSheetHolder.getSheet().getWorkbook());
        if (isHead.booleanValue()) {
            if ("\u8bc1\u4ef6\u6838\u9a8c\u72b6\u6001".equals(cell.getStringCellValue())) {
                this.checkIndex = cell.getColumnIndex();
                return;
            }
            if ("\u5b9e\u540d\u8ba4\u8bc1\u72b6\u6001".equals(cell.getStringCellValue())) {
                this.authIndex = cell.getColumnIndex();
                return;
            }
        } else {
            if (this.authIndex != null && cell.getColumnIndex() == this.authIndex.intValue() && this.getCellStyle(cell.getStringCellValue()) != null) {
                cell.setCellStyle(this.getCellStyle(cell.getStringCellValue()));
            }
            if (this.checkIndex != null && cell.getColumnIndex() == this.checkIndex.intValue() && this.getCellStyle(cell.getStringCellValue()) != null) {
                cell.setCellStyle(this.getCellStyle(cell.getStringCellValue()));
            }
        }
    }
}

