/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.apis.responses;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class UserRoleResponse
implements Serializable {
    private final String userId;
    private final Collection<UserAppItem> apps = new ArrayList<UserAppItem>();

    public String getRoleDesc() {
        if (CollectionUtils.isEmpty(this.apps)) {
            return null;
        }
        return this.apps.stream().map(ii -> ii.getDesc()).collect(Collectors.joining(";"));
    }

    public UserRoleResponse(String userId) {
        this.userId = userId;
    }

    public static UserRoleResponse create(String userId) {
        return new UserRoleResponse(userId);
    }

    public void assignApps(UserAppItem app) {
        this.getApps().add(app);
    }

    public String getUserId() {
        return this.userId;
    }

    public Collection<UserAppItem> getApps() {
        return this.apps;
    }

    public static class UserAppRoleItem
    implements Serializable {
        private final String id;
        private final String name;

        public UserAppRoleItem(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public static UserAppRoleItem create(String id, String name) {
            return new UserAppRoleItem(id, name);
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class UserAppItem
    implements Serializable {
        private final String id;
        private final String name;
        private final Collection<UserAppRoleItem> roles = new ArrayList<UserAppRoleItem>();

        public UserAppItem(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public void assignRole(String id, String name) {
            this.getRoles().add(UserAppRoleItem.create(id, name));
        }

        public String getDesc() {
            if (CollectionUtils.isEmpty(this.getRoles())) {
                return null;
            }
            return String.format("\u3010%s\u3011%s", this.getName(), this.getRoles().stream().map(ix -> ix.getName()).collect(Collectors.joining(",")));
        }

        public static UserAppItem create(String id, String name) {
            return new UserAppItem(id, name);
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Collection<UserAppRoleItem> getRoles() {
            return this.roles;
        }
    }
}

