/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.apis.controllers;

import cn.myapps.common.util.PropertiesConfig;
import cn.myapps.util.file.RemoteFileCompressor;
import com.bcxin.runtime.apis.configs.RegionConfig;
import com.bcxin.runtime.apis.controllers.SecurityControllerAbstract;
import com.bcxin.runtime.apis.requests.CompressFileToZipRequest;
import com.bcxin.runtime.apis.requests.CompressFileToZipV2Request;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.net.ssl.HttpsURLConnection;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v3/extends/compress"})
public class CompressController
extends SecurityControllerAbstract {
    private static final Logger logger = LoggerFactory.getLogger(CompressController.class);
    private final RegionConfig regionConfig;
    private final PropertiesConfig propertiesConfig;

    public CompressController(RegionConfig regionConfig, PropertiesConfig propertiesConfig) {
        this.regionConfig = regionConfig;
        this.propertiesConfig = propertiesConfig;
        HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
    }

    @PostMapping(value={"/fileIntoZip"})
    public void getFileIntoZIP(@RequestBody CompressFileToZipRequest compressFileToZipRequest, HttpServletResponse response) {
        try {
            ArrayList<String> allExtractPaths = new ArrayList<String>();
            for (String path : compressFileToZipRequest.getFilePaths()) {
                if (path == null) continue;
                if (!path.startsWith("http")) {
                    path = this.regionConfig.getSourceSite() + String.format("/obpm/%s", path).replace("//", "/");
                }
                allExtractPaths.add(path);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            String timestamp = sdf.format(new Date());
            String zipPath = this.propertiesConfig.getStorageroot() + compressFileToZipRequest.getDestDir() + timestamp + "/" + compressFileToZipRequest.getNewFileName() + ".zip";
            RemoteFileCompressor.compressRemoteFiles((String[])allExtractPaths.toArray(new String[0]), (String)zipPath);
            response.setCharacterEncoding("UTF-8");
            response.getWriter().write(zipPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @PostMapping(value={"/file-zip"})
    public void postFileIntoZIP(@RequestBody CompressFileToZipV2Request compressFileToZipV2Request, HttpServletResponse response) {
        try {
            if (compressFileToZipV2Request.getFolders() == null) {
                compressFileToZipV2Request.setFolders(new ArrayList<CompressFileToZipV2Request.CompressFileItemFolder>());
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            String timestamp = sdf.format(new Date());
            String zipPath = this.propertiesConfig.getStorageroot() + compressFileToZipV2Request.getDestDir() + timestamp + "/" + compressFileToZipV2Request.getNewFileName() + ".zip";
            CompressController.compressRemoteFiles(this.regionConfig, compressFileToZipV2Request.getFolders(), zipPath);
            response.setCharacterEncoding("UTF-8");
            response.getWriter().write(zipPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public static String compressRemoteFiles(RegionConfig regionConfig, Collection<CompressFileToZipV2Request.CompressFileItemFolder> folders, String targetZipPath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

