package com.bcxin.runtime.apis.responses;

import lombok.Getter;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.Map;

@Getter
public class DownloadChangelogResponse {
    public final String relativePath;
    private final Collection<Exception> exceptions;
    private final Map<String,String> items;
    private final boolean isSuccess;
    private final String message;
    private final String realPath;

    public DownloadChangelogResponse(String realPath,String relativePath,
                                     Map<String, String> items,
                                     Collection<Exception> exceptions,
                                     String message) {
        this.relativePath = relativePath;
        this.items = items;
        this.realPath = realPath;
        //this.exceptions = exceptions;
        this.exceptions = null;
        this.isSuccess = CollectionUtils.isEmpty(exceptions);
        this.message = message;
    }

    public static DownloadChangelogResponse create(String realPath,String relativePath,Map<String,String> items, Collection<Exception> exceptions,String message) {
        return new DownloadChangelogResponse(realPath, relativePath, items, exceptions, message);
    }
}
