package com.bcxin.runtime.apis.responses;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;

import java.util.Date;


@Getter
public class CreateTokenResponse {

    private final String assignId;
    private final String token;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private final Date expiredAt;

    public CreateTokenResponse(String assignId,String token, Date expiredAt) {
        this.assignId = assignId;
        this.token = token;
        this.expiredAt = expiredAt;
    }

    public static CreateTokenResponse create(String assignId,String token, Date expiredAt) {
        return new CreateTokenResponse(assignId,token, expiredAt);
    }
}
