package com.bcxin.runtime.apis.dtos;

import lombok.Getter;

import java.util.Collection;
import java.util.Map;

@Getter
public class ChangeLogDataResult {
    private final int offset;

    private final int pageSize;
    private final Collection<Map<String, Object>> data;
    private StringBuilder trackingBuilder = new StringBuilder();

    public ChangeLogDataResult(int offset,int pageSize,  Collection<Map<String, Object>> data) {
        this.offset = offset;
        this.data = data;
        this.pageSize = pageSize;
    }

    public static ChangeLogDataResult create(int offset,int pageSize, Collection<Map<String, Object>> data) {
        return new ChangeLogDataResult(offset, pageSize, data);
    }

    public void appendTracking(String msg) {
        trackingBuilder.append(msg);
    }
}
