package com.bcxin.runtime.apis.components;
import cn.myapps.common.dao.JDBCUtil;
import com.bcxin.runtime.apis.dtos.ChangeLogContext;
import com.bcxin.runtime.domain.constants.FieldNames;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface MappingSqlValueTranslator {
    String get(ChangeLogContext logContext, String sqlFormat, String key, Object originalValue);

    @Component
    public static class MappingSqlValueTranslatorImpl implements MappingSqlValueTranslator {
        @Override
        public String get(ChangeLogContext logContext, String sqlFormat, String key, Object originalValue) {
            String colPlaceHolder = "\\#\\{" + String.valueOf(key) + "\\}";
            String colPlaceHolder2 = "\\#\\{item_" + String.valueOf(key) + "\\}";
            Object colValue = originalValue;

            boolean isEmptyValue = false;
            try {
                if (colValue == null) {
                    isEmptyValue = true;
                    colValue = "NULL";
                    /**
                     * 判断是否为附件信息
                     */
                } else {
                    String pathFieldExpress = String.format("#{path:%s}", key);
                    if (FieldNames.isFile(String.valueOf(key)) || sqlFormat.contains(pathFieldExpress)) {
                        //paths.add(String.valueOf(colValue));
                        //对数据进行格式化操作
                        colValue = FieldNames.formattedFileValue("", "manually", "manually", String.valueOf(colValue));
                    }
                }

                if(isEmptyValue) {
                    Collection<String> spColumns = Stream.of("'", "\"", "`").collect(Collectors.toList());
                    for (String ix : spColumns) {
                        sqlFormat = sqlFormat.replaceAll(String.format("(?i)%s", ix.concat(colPlaceHolder).concat(ix)), "NULL");
                        sqlFormat = sqlFormat.replaceAll(String.format("(?i)%s", ix.concat(colPlaceHolder2).concat(ix)), "NULL");
                    }
                }

                if(key.equalsIgnoreCase(ChangeLogContext.ISTMP_COLUMN))
                {
                    String isTmpValue = getValue(colValue);
                    if(StringUtils.hasLength(isTmpValue)) {
                        isTmpValue = isTmpValue.replace("'", "");
                    }

                    sqlFormat = sqlFormat.replaceAll(String.format("(?i)%s", colPlaceHolder), isTmpValue);
                    sqlFormat = sqlFormat.replaceAll(String.format("(?i)%s", colPlaceHolder2), isTmpValue);
                }else {
                    String finialColValue = getValue(colValue);
                    sqlFormat = sqlFormat.replaceAll(String.format("(?i)%s", colPlaceHolder), finialColValue);
                    sqlFormat = sqlFormat.replaceAll(String.format("(?i)%s", colPlaceHolder2), finialColValue);
                }
                
                return sqlFormat;
            } catch (Exception ex) {
                sqlFormat = sqlFormat.replaceAll(String.format("(?i)%s", colPlaceHolder), getValue(ex.getMessage()));
                sqlFormat = sqlFormat.replaceAll(String.format("(?i)%s", colPlaceHolder2), getValue(ex.getMessage()));
            }

            return sqlFormat;
        }

        private String getValue(Object value) {
            if (value == null) {
                return String.valueOf(value);
            }

            return JDBCUtil.toSqlStringValue(value);
        }
    }
}
