/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.apis.controllers;

import cn.myapps.common.util.Security;
import cn.myapps.components.SettingProvider;
import com.bcxin.runtime.apis.requests.CreateTokenRequest;
import com.bcxin.runtime.apis.responses.CreateTokenResponse;
import io.swagger.annotations.ApiOperation;
import java.util.Calendar;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/v3/extends/identity"}, produces={"application/json;charset=UTF-8"})
public class AuthController {
    private final SettingProvider settingProvider;

    public AuthController(SettingProvider settingProvider) {
        this.settingProvider = settingProvider;
    }

    @ApiOperation(value="generateToken", notes="\u6839\u636e\u6388\u6743\u7801")
    @PostMapping(value={"/tokens"})
    public ResponseEntity generateToken(@RequestBody CreateTokenRequest request) {
        if (!StringUtils.hasLength((String)request.getAuthCode())) {
            return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body((Object)"AuthCode \u4e0d\u80fd\u4e3a\u7a7a");
        }
        String assignEmployeeId = this.settingProvider.getSettingWithCache("platform.partner.authCodes", request.getAuthCode(), 1800);
        if (!StringUtils.hasLength((String)assignEmployeeId)) {
            return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body((Object)"AuthCode\u65e0\u6548");
        }
        Calendar current = Calendar.getInstance();
        current.add(13, 3600);
        String token = Security.getToken((String)assignEmployeeId, (int)3600);
        return ResponseEntity.ok((Object)CreateTokenResponse.create(assignEmployeeId, token, current.getTime()));
    }
}

