/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.autodownloadupload.sharding.strategy;

import com.bcxin.autodownloadupload.common.utils.SpringContextUtils;
import com.bcxin.autodownloadupload.sharding.strategy.ConsistentHashAlgorithm;
import com.bcxin.autodownloadupload.sharding.strategy.InitTableNodesToHashLoop;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedMap;
import org.apache.shardingsphere.api.sharding.standard.PreciseShardingAlgorithm;
import org.apache.shardingsphere.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.api.sharding.standard.RangeShardingAlgorithm;
import org.apache.shardingsphere.api.sharding.standard.RangeShardingValue;
import org.springframework.util.CollectionUtils;

public class ConsistentShardingAlgorithm
implements PreciseShardingAlgorithm<Long>,
RangeShardingAlgorithm<Long> {
    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Long> shardingValue) {
        InitTableNodesToHashLoop initTableNodesToHashLoop = (InitTableNodesToHashLoop)SpringContextUtils.getBean(InitTableNodesToHashLoop.class);
        if (CollectionUtils.isEmpty(availableTargetNames)) {
            return shardingValue.getLogicTableName();
        }
        ArrayList<String> availableTargetNameList = new ArrayList<String>(availableTargetNames);
        String logicTableName = availableTargetNameList.get(0).replaceAll("[^(a-zA-Z_)]", "");
        SortedMap tableHashNode = (SortedMap)initTableNodesToHashLoop.getTableVirtualNodes().get(logicTableName);
        ConsistentHashAlgorithm consistentHashAlgorithm = new ConsistentHashAlgorithm(tableHashNode, availableTargetNames);
        return consistentHashAlgorithm.getTableNode(String.valueOf(shardingValue.getValue()));
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<Long> shardingValue) {
        return availableTargetNames;
    }
}

