/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.services.impls;

import com.alibaba.fastjson.JSON;
import com.bcxin.tenant.bcx.domains.entities.MetaModuleEntity;
import com.bcxin.tenant.bcx.domains.entities.MetaPageEntity;
import com.bcxin.tenant.bcx.domains.entities.MetaPageVersionEntity;
import com.bcxin.tenant.bcx.domains.repositories.MetaPageRepository;
import com.bcxin.tenant.bcx.domains.repositories.MetaPageVersionRepository;
import com.bcxin.tenant.bcx.domains.repositories.criterias.MetaPageSearchCriteria;
import com.bcxin.tenant.bcx.domains.services.MetaModuleService;
import com.bcxin.tenant.bcx.domains.services.MetaPageService;
import com.bcxin.tenant.bcx.domains.services.commands.DeleteDataCommand;
import com.bcxin.tenant.bcx.domains.services.commands.pages.BatchLogicalDeletePageCommand;
import com.bcxin.tenant.bcx.domains.services.commands.pages.CreateMetaPageCommand;
import com.bcxin.tenant.bcx.domains.services.commands.pages.LogicalDeletePageCommand;
import com.bcxin.tenant.bcx.domains.services.commands.pages.SavePageFormJsonCommand;
import com.bcxin.tenant.bcx.domains.services.commands.pages.UpdateMetaPageCommand;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.infrastructures.TenantContext;
import com.bcxin.tenant.bcx.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.bcx.infrastructures.UnitWork;
import com.bcxin.tenant.bcx.infrastructures.components.IdWorker;
import com.bcxin.tenant.bcx.infrastructures.components.JsonProvider;
import com.bcxin.tenant.bcx.infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.tenant.bcx.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.bcx.infrastructures.exceptions.NoFoundTenantException;
import com.bcxin.tenant.bcx.infrastructures.exceptions.UnAuthorizedTenantException;
import com.bcxin.tenant.bcx.infrastructures.snapshots.metas.MetaPageStructureSettingSnapshot;
import com.bcxin.tenant.bcx.infrastructures.utils.StringUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class MetaPageServiceImpl
implements MetaPageService {
    private final MetaPageRepository pageRepository;
    private final MetaPageVersionRepository versionRepository;
    private final MetaModuleService moduleService;
    private final UnitWork unitWork;
    private final IdWorker idWorker;
    private final JsonProvider jsonProvider;

    public MetaPageServiceImpl(MetaPageRepository pageRepository, MetaPageVersionRepository versionRepository, MetaModuleService moduleService, UnitWork unitWork, IdWorker idWorker, JsonProvider jsonProvider) {
        this.pageRepository = pageRepository;
        this.versionRepository = versionRepository;
        this.moduleService = moduleService;
        this.unitWork = unitWork;
        this.idWorker = idWorker;
        this.jsonProvider = jsonProvider;
    }

    @Override
    public String dispatch(CreateMetaPageCommand command) {
        command.validate();
        if (StringUtil.isEmpty((String)command.getName())) {
            throw new ArgumentTenantException("\u9875\u9762\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (command.getPageType() == null) {
            throw new ArgumentTenantException("\u9875\u9762\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (userModel == null) {
            throw new UnAuthorizedTenantException();
        }
        String projectId = null;
        if (Objects.nonNull(command.getModuleId())) {
            MetaModuleEntity module = this.moduleService.getById(command.getModuleId());
            if (module == null) {
                throw new ArgumentTenantException("\u6a21\u5757\u4e0d\u5b58\u5728: " + command.getModuleId());
            }
            projectId = module.getProjectId();
        }
        if (StringUtil.isEmpty(projectId)) {
            throw new BadTenantException("\u9879\u76ee\u65e0\u6548");
        }
        String validatedFormJson = this.validateAndNormalizeJson(command.getFormJson());
        String id = String.valueOf(this.idWorker.getNextId());
        MetaPageEntity entity = MetaPageEntity.create(id, projectId, command.getModuleId(), command.getName(), command.getNote(), command.getSlug(), command.getLogo(), command.getPageType(), command.getBusinessType(), command.getTableName(), command.isEnableBPMFlow(), command.isEnableAnonymousAccess(), validatedFormJson, userModel.getUserType(), userModel.getOrganizationId(), userModel.getEmployeeId(), userModel.getName(), command.isSync2Identity(), command.getBeginTime(), command.getEndTime(), command.getAttachment(), command.getLimitedCount());
        entity.setVersion(1L);
        entity.setDeleted(false);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        entity.setCreatedTime(now);
        entity.setLastUpdatedTime(now);
        MetaPageVersionEntity versionEntity = null;
        if (!StringUtil.isEmpty((String)validatedFormJson)) {
            versionEntity = MetaPageVersionEntity.create(String.valueOf(this.idWorker.getNextId()), id, 1L, validatedFormJson, entity.getFormSettingJson(), now);
        }
        MetaPageVersionEntity finalVersionEntity = versionEntity;
        this.unitWork.executeTran(() -> {
            this.pageRepository.insert(entity);
            if (finalVersionEntity != null) {
                this.versionRepository.insert(finalVersionEntity);
            }
        });
        return id;
    }

    @Override
    public void dispatch(UpdateMetaPageCommand command) {
        command.validate();
        String validatedFormJson = this.validateAndNormalizeJson(command.getFormJson());
        String validatedSettingJson = this.validateAndNormalizeJson(command.getFormSettingJson());
        this.unitWork.executeTran(() -> {
            MetaPageEntity entity = this.getByIdIncludeDeleted(command.getId());
            if (entity == null) {
                throw new NoFoundTenantException();
            }
            if (entity.isDeleted()) {
                throw new NoFoundTenantException();
            }
            boolean formJsonChanged = false;
            boolean formSettingJsonChanged = false;
            TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
            entity.change(command.getName() != null ? command.getName() : entity.getName(), command.getNote() != null ? command.getNote() : entity.getNote(), command.getSlug() != null ? command.getSlug() : entity.getSlug(), command.getLogo() != null ? command.getLogo() : entity.getLogo(), command.getPageType() != null ? command.getPageType() : entity.getPageType(), command.getBusinessType() != null ? command.getBusinessType() : entity.getBusinessType(), command.getTableName() != null ? command.getTableName() : entity.getTableName(), command.getEnableBPMFlow(), command.getEnableAnonymousAccess(), command.isSync2Identity(), command.getBeginTime(), command.getEndTime(), command.getAttachment(), command.getLimitedCount(), userModel);
            if (validatedFormJson != null && !validatedFormJson.equals(entity.getFormJson())) {
                formJsonChanged = true;
            }
            if (validatedSettingJson != null && !validatedSettingJson.equals(entity.getFormSettingJson())) {
                formSettingJsonChanged = true;
            }
            if (formJsonChanged || formSettingJsonChanged) {
                entity.changeVersion(entity.getVersion() + 1L);
            }
            entity.change(validatedFormJson != null ? validatedFormJson : entity.getFormJson(), validatedSettingJson != null ? validatedSettingJson : entity.getFormSettingJson(), TenantContext.getInstance().getUserContext().get());
            this.pageRepository.update(entity);
            if (formJsonChanged || formSettingJsonChanged) {
                MetaPageVersionEntity versionEntity = MetaPageVersionEntity.create(String.valueOf(this.idWorker.getNextId()), entity.getId(), entity.getVersion(), entity.getFormJson(), entity.getFormSettingJson(), entity.getLastUpdatedTime());
                this.versionRepository.insert(versionEntity);
            }
        });
    }

    @Override
    public void dispatch(SavePageFormJsonCommand command) {
        command.validate();
        String validatedFormJson = this.validateAndNormalizeJson(command.getFormJson());
        String validatedSettingJson = this.validateAndNormalizeJson(command.getFormSettingJson());
        this.unitWork.executeTran(() -> {
            MetaPageEntity entity = this.getByIdIncludeDeleted(command.getId());
            if (entity == null) {
                throw new NoFoundTenantException();
            }
            if (entity.isDeleted()) {
                throw new NoFoundTenantException();
            }
            boolean formJsonChanged = false;
            boolean formSettingJsonChanged = false;
            if (validatedFormJson != null && !validatedFormJson.equals(entity.getFormJson())) {
                formJsonChanged = true;
            }
            if (validatedSettingJson != null && !validatedSettingJson.equals(entity.getFormSettingJson())) {
                formSettingJsonChanged = true;
            }
            if (formJsonChanged || formSettingJsonChanged) {
                entity.changeVersion(entity.getVersion() + 1L);
            }
            entity.change(validatedFormJson != null ? validatedFormJson : entity.getFormJson(), validatedSettingJson != null ? validatedSettingJson : entity.getFormSettingJson(), TenantContext.getInstance().getUserContext().get());
            this.pageRepository.update(entity);
            if (formJsonChanged || formSettingJsonChanged) {
                MetaPageVersionEntity versionEntity = MetaPageVersionEntity.create(String.valueOf(this.idWorker.getNextId()), entity.getId(), entity.getVersion(), entity.getFormJson(), entity.getFormSettingJson(), entity.getLastUpdatedTime());
                this.versionRepository.insert(versionEntity);
            }
        });
    }

    @Override
    public void dispatch(DeleteDataCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> {
            MetaPageEntity entity = this.getByIdIncludeDeleted(command.getId());
            if (entity == null) {
                throw new NoFoundTenantException();
            }
            if (entity.isDeleted()) {
                throw new NoFoundTenantException();
            }
            this.pageRepository.delete(command.getId());
        });
    }

    @Override
    public void dispatch(LogicalDeletePageCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> {
            MetaPageEntity entity = this.getByIdIncludeDeleted(command.getId());
            if (entity == null) {
                throw new NoFoundTenantException();
            }
            if (entity.isDeleted()) {
                throw new NoFoundTenantException();
            }
            TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
            entity.changeMarkAsDeleted(userModel);
            this.pageRepository.update(entity);
        });
    }

    @Override
    public void dispatch(BatchLogicalDeletePageCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> {
            List<String> ids = command.getIds();
            if (ids == null || ids.isEmpty()) {
                return;
            }
            List<MetaPageEntity> entities = this.pageRepository.getByIds(ids);
            ArrayList<String> validIds = new ArrayList<String>();
            for (MetaPageEntity entity : entities) {
                if (entity == null || entity.isDeleted()) continue;
                validIds.add(entity.getId());
            }
            if (validIds.isEmpty()) {
                return;
            }
            Timestamp now = new Timestamp(System.currentTimeMillis());
            this.pageRepository.batchMarkAsDeleted(validIds, now);
        });
    }

    @Override
    public EntityCollection<MetaPageEntity> search(MetaPageSearchCriteria criteria) {
        return this.pageRepository.search(criteria);
    }

    @Override
    public MetaPageEntity getById(String id) {
        MetaPageEntity entity = (MetaPageEntity)this.pageRepository.getById(id);
        if (entity != null && entity.isDeleted()) {
            return null;
        }
        return entity;
    }

    @Override
    public List<MetaPageEntity> getByIds(List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        List<MetaPageEntity> entities = this.pageRepository.getByIds(ids);
        return entities.stream().filter(entity -> entity != null && !entity.isDeleted()).collect(Collectors.toList());
    }

    private MetaPageEntity getByIdIncludeDeleted(String id) {
        return (MetaPageEntity)this.pageRepository.getById(id);
    }

    @Override
    public MetaPageStructureSettingSnapshot getPageSetting(String id) {
        MetaPageEntity entity = this.getById(id);
        if (entity == null) {
            throw new NoFoundTenantException();
        }
        return (MetaPageStructureSettingSnapshot)this.jsonProvider.toObject(MetaPageStructureSettingSnapshot.class, entity.getFormSettingJson());
    }

    private String validateAndNormalizeJson(String json) {
        if (json == null || json.trim().isEmpty()) {
            return null;
        }
        try {
            JSON.parse((String)json);
            return json;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684JSON\u683c\u5f0f: " + e.getMessage());
        }
    }
}

