package com.bcxin.tenant.bcx.domains.services.impls;

import com.bcxin.tenant.bcx.domains.entities.DynamicPageDataEntity;
import com.bcxin.tenant.bcx.domains.entities.MetaPageEntity;
import com.bcxin.tenant.bcx.domains.repositories.DynamicPageDataRepository;
import com.bcxin.tenant.bcx.domains.repositories.MetaPageRepository;
import com.bcxin.tenant.bcx.domains.services.DynamicPageDataService;
import com.bcxin.tenant.bcx.domains.services.commands.dynamics.BatchDynamicPageDataCommand;
import com.bcxin.tenant.bcx.domains.services.commands.dynamics.CreateDynamicPageDataCommand;
import com.bcxin.tenant.bcx.domains.services.commands.dynamics.DeleteDynamicPageDataCommand;
import com.bcxin.tenant.bcx.domains.services.commands.dynamics.UpdateDynamicPageDataCommand;
import com.bcxin.tenant.bcx.domains.snapshots.DynamicPageDataJsonSnapshot;
import com.bcxin.tenant.bcx.infrastructures.TenantContext;
import com.bcxin.tenant.bcx.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.bcx.infrastructures.UnitWork;
import com.bcxin.tenant.bcx.infrastructures.components.IdWorker;
import com.bcxin.tenant.bcx.infrastructures.components.JsonProvider;
import com.bcxin.tenant.bcx.infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.tenant.bcx.infrastructures.exceptions.NoFoundTenantException;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
public class DynamicPageDataServiceImpl implements DynamicPageDataService {

    private final UnitWork unitWork;
    private final IdWorker idWorker;
    private final DynamicPageDataRepository dynamicPageDataRepository;
    private final MetaPageRepository pageRepository;

    private final JsonProvider jsonProvider;

    public DynamicPageDataServiceImpl(UnitWork unitWork, IdWorker idWorker,
                                      DynamicPageDataRepository dynamicPageDataRepository,
                                      MetaPageRepository pageRepository, JsonProvider jsonProvider) {
        this.unitWork = unitWork;
        this.idWorker = idWorker;
        this.dynamicPageDataRepository = dynamicPageDataRepository;
        this.pageRepository = pageRepository;
        this.jsonProvider = jsonProvider;
    }


    @Override
    public String dispatch(CreateDynamicPageDataCommand command) {
        MetaPageEntity page = this.pageRepository.getById(command.getPageId());
        if (page == null) {
            throw new NoFoundTenantException();
        }

        TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
        String id = String.valueOf(idWorker.getNextId());
        this.unitWork.executeTran(() -> {
            DynamicPageDataEntity entity = DynamicPageDataEntity.create(
                    id,
                    userModel,
                    page
            );
            DynamicPageDataJsonSnapshot snapshot =
                    DynamicPageDataJsonSnapshot.create(getProcessedItemMap(command.getItems()));

            entity.change(snapshot,this.jsonProvider,userModel);

            this.dynamicPageDataRepository.insert(entity);
        });

        return id;
    }

    @Override
    public void dispatch(UpdateDynamicPageDataCommand command) {
        /**
         * todo: 权限验证
         */
        DynamicPageDataEntity entity = this.dynamicPageDataRepository.getById(command.getPageId(), command.getId());
        if (entity == null) {
            throw new NoFoundTenantException();
        }

        if (!entity.getPageId().equals(command.getPageId())) {
            throw new ArgumentTenantException("参数不匹配");
        }

        TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
        Map<String,Object> items = getProcessedItemMap(command.getItems());

        DynamicPageDataJsonSnapshot snapshot =
                DynamicPageDataJsonSnapshot.create(items);

        entity.change(snapshot,this.jsonProvider,userModel);

        this.unitWork.executeTran(() -> {
            this.dynamicPageDataRepository.update(entity);
        });
    }

    @Override
    public void dispatch(DeleteDynamicPageDataCommand command) {
        DynamicPageDataEntity entity = this.dynamicPageDataRepository.getById(command.getPageId(), command.getId());
        if (entity == null) {
            throw new NoFoundTenantException();
        }

        /**
         * todo: 权限验证
         */
        this.unitWork.executeTran(() -> {
            this.dynamicPageDataRepository.delete(command.getPageId(), command.getId());
        });
    }

    @Override
    public void dispatch(BatchDynamicPageDataCommand command) {
        this.unitWork.executeTran(() -> {
            for (Map<String, Object> item : command.getItems()) {
                this.dispatch(CreateDynamicPageDataCommand.create(
                        command.getPageId(), item
                ));
            }
        });
    }

    private Map<String,Object> getProcessedItemMap(Map<String,Object> map) {
        TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (userModel != null) {
            map = (userModel.fillAndReturnMap(map));
        }

        return map;
    }
}
