package com.bcxin.tenant.bcx.domains.services.commands.projects;

import com.bcxin.tenant.bcx.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.MetaCreatorReferenceType;
import lombok.Getter;

@Getter
public class CreateMetaProjectCommand extends CommandAbstract {
    private final String id;
    private final String name;
    private final String note;
    private final boolean enabled;
    private final String logo;
    private final String slug;

    public CreateMetaProjectCommand(String id, String name, String note, boolean enabled, String logo, String slug) {
        this.id = id;
        this.name = name;
        this.note = note;
        this.enabled = enabled;
        this.logo = logo;
        this.slug = slug;
    }

    public static CreateMetaProjectCommand create(String id, String name, String note, boolean enabled, String logo, String slug) {
        return new CreateMetaProjectCommand(id, name, note, enabled, logo, slug);
    }

    public static CreateMetaProjectCommand create(String id, String name, String note, boolean enabled) {
        return new CreateMetaProjectCommand(id, name, note, enabled, null, null);
    }
}