package com.bcxin.tenant.bcx.domains.services.commands.modules;

import com.bcxin.tenant.bcx.infrastructures.commands.CommandAbstract;

import java.util.List;

/**
 * 批量逻辑删除模块命令
 */
public class BatchLogicalDeleteModuleCommand extends CommandAbstract {
    private final List<String> ids;

    public BatchLogicalDeleteModuleCommand(List<String> ids) {
        this.ids = ids;
    }

    public List<String> getIds() {
        return ids;
    }

    @Override
    public void validate() {
        if (ids == null || ids.isEmpty()) {
            throw new IllegalArgumentException("模块ID列表不能为空");
        }
    }
}

