package com.bcxin.tenant.bcx.domains.services;

import com.bcxin.tenant.bcx.domains.entities.MetaPageEntity;
import com.bcxin.tenant.bcx.domains.repositories.criterias.MetaPageSearchCriteria;
import com.bcxin.tenant.bcx.domains.services.commands.DeleteDataCommand;
import com.bcxin.tenant.bcx.domains.services.commands.pages.BatchLogicalDeletePageCommand;
import com.bcxin.tenant.bcx.domains.services.commands.pages.CreateMetaPageCommand;
import com.bcxin.tenant.bcx.domains.services.commands.pages.LogicalDeletePageCommand;
import com.bcxin.tenant.bcx.domains.services.commands.pages.SavePageFormJsonCommand;
import com.bcxin.tenant.bcx.domains.services.commands.pages.UpdateMetaPageCommand;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.infrastructures.snapshots.metas.MetaPageStructureSettingSnapshot;

import java.util.List;

/**
 * 页面元数据服务接口
 */
public interface MetaPageService {
    String dispatch(CreateMetaPageCommand command);

    void dispatch(UpdateMetaPageCommand command);

    /**
     * 保存页面表单JSON（只更新formJson和settingJson）
     */
    void dispatch(SavePageFormJsonCommand command);

    void dispatch(DeleteDataCommand command);

    /**
     * 逻辑删除页面
     */
    void dispatch(LogicalDeletePageCommand command);

    /**
     * 批量逻辑删除页面
     */
    void dispatch(BatchLogicalDeletePageCommand command);

    EntityCollection<MetaPageEntity> search(MetaPageSearchCriteria criteria);

    MetaPageEntity getById(String id);

    /**
     * 批量根据ID获取页面（不包括已删除的记录）
     */
    List<MetaPageEntity> getByIds(List<String> ids);

    /**
     * 获取页面设置信息
     * @param id 页面ID
     * @return 页面设置快照，包含字段信息
     */
    MetaPageStructureSettingSnapshot getPageSetting(String id);
}

