package com.bcxin.tenant.bcx.domains.services;

import com.bcxin.tenant.bcx.domains.entities.MetaMenuEntity;
import com.bcxin.tenant.bcx.domains.repositories.criterias.MetaMenuSearchCriteria;
import com.bcxin.tenant.bcx.domains.services.commands.DeleteDataCommand;
import com.bcxin.tenant.bcx.domains.services.commands.menus.CreateMetaMenuCommand;
import com.bcxin.tenant.bcx.domains.services.commands.menus.UpdateMetaMenuCommand;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;

/**
 * 菜单元数据服务接口
 */
public interface MetaMenuService {
    void dispatch(CreateMetaMenuCommand command);

    void dispatch(UpdateMetaMenuCommand command);

    void dispatch(DeleteDataCommand command);

    EntityCollection<MetaMenuEntity> search(MetaMenuSearchCriteria criteria);

    MetaMenuEntity getById(String id);
}
