package com.bcxin.tenant.bcx.domains.repositories.criterias;

import lombok.Getter;

import java.util.List;

/**
 * 企业注册表单搜索条件
 */
@Getter
public class OrganRegistryFormsSearchCriteria {
    private final String id;
    private final List<String> ids;
    private final String institutionalTypeCode;
    private final String industryTypeCode;
    private final String regionCode;
    private final String pageId;
    private final Integer referenceType;
    private final String referenceNumber;
    private final String creatorId;
    private final int pageIndex;
    private final int pageSize;

    private OrganRegistryFormsSearchCriteria(String id, List<String> ids, String institutionalTypeCode,
                                           String industryTypeCode, String regionCode, String pageId,
                                           Integer referenceType, String referenceNumber, String creatorId,
                                           int pageIndex, int pageSize) {
        this.id = id;
        this.ids = ids;
        this.institutionalTypeCode = institutionalTypeCode;
        this.industryTypeCode = industryTypeCode;
        this.regionCode = regionCode;
        this.pageId = pageId;
        this.referenceType = referenceType;
        this.referenceNumber = referenceNumber;
        this.creatorId = creatorId;
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
    }

    public static OrganRegistryFormsSearchCriteria create(String id, List<String> ids, String institutionalTypeCode,
                                                         String industryTypeCode, String regionCode, String pageId,
                                                         Integer referenceType, String referenceNumber, String creatorId,
                                                         int pageIndex, int pageSize) {
        return new OrganRegistryFormsSearchCriteria(id, ids, institutionalTypeCode, industryTypeCode, regionCode,
                pageId, referenceType, referenceNumber, creatorId, pageIndex, pageSize);
    }
}
