package com.bcxin.tenant.bcx.domains.repositories.criterias;

import com.bcxin.tenant.bcx.infrastructures.criterias.CriteriaAbstract;
import lombok.Getter;

import java.util.List;

@Getter
public class MetaProjectSearchCriteria extends CriteriaAbstract {
    private final String id;
    private final List<String> ids;
    private final String name;
    private final String note;
    private final Boolean enabled;
    private final String slug;

    public MetaProjectSearchCriteria(String id, List<String> ids, String name, String note, Boolean enabled, String slug, int pageIndex, int pageSize) {
        super(pageIndex,pageSize);

        this.id = id;
        this.ids = ids;
        this.name = name;
        this.note = note;
        this.enabled = enabled;
        this.slug = slug;
    }

    public static MetaProjectSearchCriteria create(String id, List<String> ids, String name, String note, Boolean enabled, String slug, int pageIndex, int pageSize){
        return new MetaProjectSearchCriteria(id, ids, name, note, enabled, slug, pageIndex, pageSize);
    }
}
