package com.bcxin.tenant.bcx.domains.repositories;

import com.bcxin.tenant.bcx.domains.entities.MetaModuleEntity;
import com.bcxin.tenant.bcx.domains.repositories.criterias.MetaModuleSearchCriteria;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.infrastructures.repositories.RepositoryBase;

import java.sql.Timestamp;
import java.util.List;

/**
 * 模块元数据仓库接口
 */
public interface MetaModuleRepository extends RepositoryBase<MetaModuleEntity> {
    EntityCollection<MetaModuleEntity> search(MetaModuleSearchCriteria criteria);

    /**
     * 批量查询模块
     * @param ids ID列表
     * @return 模块列表
     */
    List<MetaModuleEntity> getByIds(List<String> ids);

    /**
     * 批量标记为已删除
     * @param ids ID列表
     * @param updateTime 更新时间
     */
    void batchMarkAsDeleted(List<String> ids, Timestamp updateTime);
}
