package com.bcxin.tenant.bcx.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.bcx.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.bcx.infrastructures.entities.Aggregate;
import com.bcxin.tenant.bcx.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.MetaCreatorReferenceType;
import com.bcxin.tenant.bcx.infrastructures.enums.MetaProjectType;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;

@Data
@TableName(value = "meta_projects",autoResultMap = true)
public class MetaProjectEntity extends EntityAbstract implements Aggregate {

    @TableId(value = "id")
    private String id;

    @TableField(value = "name")
    private String name;

    @TableField(value = "note")
    private String note;

    @TableField(value = "enabled")
    private boolean enabled;

    @TableField(value = "logo")
    private String logo;

    /**
     * 页面的标识
     */
    @TableField(value = "slug")
    private String slug;

    /**
     * 项目类型
     */
    @TableField(value = "type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private MetaProjectType type;

    /**
     * 创造者类型: 0-平台, 1-租户, 2-用户
     */
    @TableField(value = "reference_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private MetaCreatorReferenceType referenceType;

    /**
     * 创建者标识(平台组织Id/租户Id/用户Id)
     */
    @TableField(value = "reference_number")
    private String referenceNumber;

    /**
     * 创作者Id
     */
    @TableField(value = "creator_id")
    private String creatorId;

    /**
     * 最后修改人Id
     */
    @TableField(value = "last_updater_id")
    private String lastUpdaterId;

    /**
     * 是否已删除: 0-未删除, 1-已删除
     */
    @TableField(value = "deleted")
    private boolean deleted;

    @TableField(value = "last_updated_Time")
    private Timestamp lastUpdatedTime;

    @TableField(value = "created_time")
    private Timestamp createdTime;

    public static MetaProjectEntity create(String id, String name, String note, boolean enabled, String logo, String slug,
                                          MetaCreatorReferenceType referenceType, String referenceNumber, 
                                          String creatorId) {
        MetaProjectEntity entity = new MetaProjectEntity();
        entity.id = id;
        entity.name = name;
        entity.note = note;
        entity.enabled = enabled;
        entity.logo = logo;
        entity.slug = slug != null ? slug : "";
        entity.referenceType = referenceType;
        entity.referenceNumber = referenceNumber;
        entity.creatorId = creatorId;
        entity.lastUpdaterId = null;
        entity.deleted = false; // 默认未删除
        return entity;
    }

    public void change(String name, String note, boolean enabled, String logo, String slug, TenantEmployeeContext.TenantUserModel userModel) {
        this.name = name;
        this.note = note;
        this.enabled = enabled;
        this.logo = logo;
        if (slug != null) {
            this.slug = slug;
        }
        this.lastUpdaterId = userModel.getId();
        this.lastUpdatedTime = new Timestamp(System.currentTimeMillis());
    }

    /**
     * 逻辑删除
     */
    public void changeMarkAsDeleted(TenantEmployeeContext.TenantUserModel userModel) {
        this.deleted = true;
        this.lastUpdaterId = userModel.getId();
        this.lastUpdatedTime = new Timestamp(System.currentTimeMillis());
    }
}
