package com.bcxin.tenant.bcx.domains.criterias;

import com.bcxin.tenant.bcx.infrastructures.criterias.CriteriaAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.MetaCreatorReferenceType;
import lombok.Getter;

import java.util.Collection;

@Getter
public class ExamEnrollmentCriteria extends CriteriaAbstract {
    private final MetaCreatorReferenceType creatorReferenceType;
    private final String referenceNumber;
    private final String name;
    private final Collection<String> subjectNumbers;

    public ExamEnrollmentCriteria(MetaCreatorReferenceType creatorReferenceType, String referenceNumber,
                                  String name, Collection<String> subjectNumbers) {
        this.creatorReferenceType = creatorReferenceType;
        this.referenceNumber = referenceNumber;
        this.name = name;
        this.subjectNumbers = subjectNumbers;
    }

    public static ExamEnrollmentCriteria create(MetaCreatorReferenceType creatorReferenceType, String referenceNumber,
                                                String name, Collection<String> subjectNumbers) {
        return new ExamEnrollmentCriteria(creatorReferenceType, referenceNumber, name, subjectNumbers);
    }
}
