package com.bcxin.tenant.bcx.backend.tasks.utils;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.tenant.bcx.infrastructures.components.JsonProvider;
import lombok.Getter;
import org.apache.logging.log4j.util.Strings;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DebeziumUtil {
    public static Collection<String> extract(JsonProvider jsonProvider, String json, String field) {
        String beforeValue = extract(jsonProvider, json, "before", field);
        String afterValue = extract(jsonProvider, json, "after", field);
        Collection<String> empIds = new HashSet<>();

        if(StringUtils.hasLength(afterValue)){
            empIds.add(afterValue);
        }

        if(StringUtils.hasLength(beforeValue)){
            empIds.add(beforeValue);
        }

        return empIds;

        /*
        if (!StringUtils.hasLength(json)) {
            return Collections.EMPTY_LIST;
        }

        JSONObject data =
                jsonProvider.toObject(JSONObject.class, json);
        if (data == null) {
            return Collections.EMPTY_LIST;
        }

        JSONObject beforeNode = data.getJSONObject("before");
        JSONObject afterNode = data.getJSONObject("after");

        JSONObject node = afterNode == null ? beforeNode : afterNode;
        if(node==null) {
            return Collections.EMPTY_LIST;
        }

        String key = node.keySet().stream()
                .filter(ix -> ix.equalsIgnoreCase(field)).findFirst().orElse(null);
        if (key == null) {
            return Collections.EMPTY_LIST;
        }

        Object value = node.get(key);
        Collection<String> empIds = new HashSet<>();
        if (value != null) {
            empIds.add(String.valueOf(value));
        }

        if (beforeNode!=null && node != beforeNode) {
            value = beforeNode.get(key);
            if (value != null) {
                empIds.add(String.valueOf(value));
            }
        }

        return empIds;
         */
    }

    public static String extract(JsonProvider jsonProvider, String json, String parent, String field) {
        if (!StringUtils.hasLength(json)) {
            return Strings.EMPTY;
        }

        JSONObject data =
                jsonProvider.toObject(JSONObject.class, json);
        if (data == null) {
            return Strings.EMPTY;
        }

        JSONObject node = data.getJSONObject(parent);
        if (node == null) {
            return Strings.EMPTY;
        }

        String key = node.keySet().stream()
                .filter(ix -> ix.equalsIgnoreCase(field)).findFirst().orElse(null);
        if (key == null) {
            return Strings.EMPTY;
        }

        Object value = node.get(key);
        if (value != null) {
            return String.valueOf(value);
        }

        return Strings.EMPTY;
    }

    public static Collection<ExtractDebeziumItem> extractItems(JsonProvider jsonProvider, String json,String... fields) {
        if (!StringUtils.hasLength(json)) {
            return Collections.EMPTY_LIST;
        }

        JSONObject data =
                jsonProvider.toObject(JSONObject.class, json);
        if (data == null) {
            return Collections.EMPTY_LIST;
        }

        JSONObject beforeNode = data.getJSONObject("before");
        JSONObject afterNode = data.getJSONObject("after");

        JSONObject node = afterNode == null ? beforeNode : afterNode;
        if (node == null) {
            return Collections.EMPTY_LIST;
        }

        DebeziumItemStatus status = DebeziumItemStatus.Edited;
        if (afterNode == null) {
            status = DebeziumItemStatus.Deleted;
        } else if (beforeNode == null) {
            status = DebeziumItemStatus.Created;
        }

        Collection<ExtractDebeziumItem> debeziumItems = new HashSet<>();
        for (String fd : fields) {
            String key = node.keySet().stream()
                    .filter(ix -> ix.equalsIgnoreCase(fd)).findFirst().orElse(null);
            if (key == null) {
                continue;
            }

            String beforeValue = null;
            String afterValue = null;

            Object value = node.get(key);

            if (value != null) {
                if (node == afterNode) {
                    afterValue = String.valueOf(value);
                } else {
                    beforeValue = String.valueOf(value);
                }
            }

            if (beforeNode != null && node != beforeNode) {
                value = beforeNode.get(key);
                if (value != null) {
                    beforeValue = String.valueOf(value);
                }
            }

            ExtractDebeziumItem selectedItem =
                    ExtractDebeziumItem.create(status, key, beforeValue, afterValue);

            debeziumItems.add(selectedItem);
        }

        return debeziumItems;
    }

    @Getter
    public static class ExtractDebeziumItem {
        private DebeziumItemStatus status;
        private Collection<String> values;
        private String name;

        private String beforeValue;
        private String afterValue;

        private Collection<ExtractDebeziumItem> relations;

        public static ExtractDebeziumItem create(DebeziumItemStatus status,String name,String beforeValue,String afterValue) {
            ExtractDebeziumItem item = new ExtractDebeziumItem();
            item.name = name;
            item.status = status;
            item.values = Stream.of(afterValue, beforeValue).filter(ii -> StringUtils.hasLength(ii)).collect(Collectors.toSet());
            item.relations = new HashSet<>();
            item.beforeValue = beforeValue;
            item.afterValue = afterValue;

            return item;
        }

        public void assignRelations(Collection<ExtractDebeziumItem> relations) {
            this.relations = relations;

            if (this.relations == null) {
                this.relations = new HashSet<>();
            }
        }
    }

    public static enum DebeziumItemStatus {
        Created,
        Edited,
        Deleted
    }
}
