package com.bcxin.tenant.bcx.backend.tasks.rings.components;

import com.bcxin.tenant.bcx.infrastructures.events.ObjectEvent;
import com.lmax.disruptor.RingBuffer;

public class RingBufferProducer {
    private final RingBuffer<ObjectEvent<?>> ringBuffer;

    public RingBufferProducer(RingBuffer<ObjectEvent<?>> ringBuffer) {
        this.ringBuffer = ringBuffer;
    }

    public <T> void publish(T data) {
        long sequence = ringBuffer.next();
        ObjectEvent ringBufferEvent = ringBuffer.get(sequence);
        ringBufferEvent.setData(data);

        ringBuffer.publish(sequence);
    }
}
