package com.bcxin.tenant.bcx.backend.tasks.configs;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.tenant.bcx.backend.tasks.utils.DebeziumUtil;
import com.bcxin.tenant.bcx.infrastructures.components.JsonProvider;
import com.bcxin.tenant.bcx.infrastructures.utils.StringUtil;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class KafkaComponentAbstract {
    private static final Logger logger = LoggerFactory.getLogger(KafkaComponent.class);
    protected final JsonProvider jsonProvider;

    protected KafkaComponentAbstract(JsonProvider jsonProvider) {
        this.jsonProvider = jsonProvider;
    }

    protected void executeConsumeData(
            List<ConsumerRecord<String, String>> records,
            Acknowledgment ack) {
        if (CollectionUtils.isEmpty(records)) {
            logger.error("无效订阅数据:{}", records);
            return;
        }
    }

    protected static void handleDeadLetterQueueData(JsonProvider jsonProvider,
                                                  List<ConsumerRecord<String, String>> selectedRecords) throws Exception {
    }

    protected static Collection<String> extractOrgFromJson(List<ConsumerRecord<String, String>> records, JsonProvider jsonProvider) {
        if (CollectionUtils.isEmpty(records)) {
            return null;
        }

        Collection<String> contents =
                records.stream().map(ii -> {
                    JSONObject data =
                            jsonProvider.toObject(JSONObject.class, ii.value());
                    if (data == null) {
                        return null;
                    }
                    JSONObject beforeNode = data.getJSONObject("before");
                    JSONObject afterNode = data.getJSONObject("after");

                    JSONObject node = afterNode == null ? beforeNode : afterNode;
                    if (node == null) {
                        return null;
                    }

                    String superviseDepartIdFieldName = "supervise_depart_id";
                    String beforeSuperviseDepartId = null;
                    String afterSuperviseDepartId = null;
                    Optional<String> superviseDepartIdFieldOptional = node.keySet().stream().filter(ix -> ix.equalsIgnoreCase(superviseDepartIdFieldName))
                            .findFirst();
                    if (!superviseDepartIdFieldOptional.isPresent()) {
                        return null;
                    }

                    if (beforeNode != null) {
                        beforeSuperviseDepartId = beforeNode.getString(superviseDepartIdFieldOptional.get());
                    }
                    if (afterNode != null) {
                        afterSuperviseDepartId = afterNode.getString(superviseDepartIdFieldOptional.get());
                    }

                    if (StringUtil.isEqual(beforeSuperviseDepartId, afterSuperviseDepartId)) {
                        return null;
                    }

                    /*
                    return ProprietorOrgWrapContent.ProprietorOrgContent.create(
                            node.getString("id"),
                            node.getString("name"),
                            node.getString("supervise_depart_id"),
                            node.getString("supervise_depart_name")
                    );
                     */

                    return node.getString("id");
                }).filter(ii -> ii != null).collect(Collectors.toList());

        if (CollectionUtils.isEmpty(contents)) {
            return null;
        }


        return contents;
    }

    protected Collection<String> extractFieldFromJson(String json,String field) {
        return DebeziumUtil.extract(jsonProvider, json, field);
    }

    protected String extractFieldFromJson(String json,String parent, String field) {
        return DebeziumUtil.extract(jsonProvider, json,parent, field);
    }

        
    protected void doExecute(String topic,
                           Runnable action,
                           Collection<String> data,
                           Acknowledgment acknowledgment) {
        action.run();

        logger.warn("完成执行变更消费主题({})-数据为:{}",
                topic,
                data.size()
        );

        acknowledgment.acknowledge();
    }

    protected Collection<String> extractTopicsFromRecords(List<ConsumerRecord<String, String>> records) {
        if (CollectionUtils.isEmpty(records)) {
            return Collections.EMPTY_LIST;
        }

        Collection<String> topics = records.stream()
                .map(ix -> ix.topic()).distinct()
                .collect(Collectors.toList());

        return topics;
    }

    protected List<ConsumerRecord<String, String>> getMatchRecords(List<ConsumerRecord<String, String>> records, String topic) {
        return records.stream()
                .filter(ii -> ii.topic().equalsIgnoreCase(topic))
                .collect(Collectors.toList());
    }

    protected Collection<String> extractIdsFromRecords(List<ConsumerRecord<String, String>> records) {
        return records.stream()
                .map(ix -> ix.key()).distinct()
                .collect(Collectors.toList());
    }
}
