/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.utils;

import com.bcxin.tenant.open.document.domains.documents.RoomDocument;
import com.bcxin.tenant.open.document.domains.repositories.RoomDocumentRepository;
import com.bcxin.tenant.open.domains.BillPaymentRuleConfig;
import com.bcxin.tenant.open.domains.dtos.RoomCommunicatedGroupDTO;
import com.bcxin.tenant.open.domains.entities.RoomUserEntity;
import com.bcxin.tenant.open.domains.utils.TencentConstants;
import com.bcxin.tenant.open.domains.views.TencentCallbackLogView;
import com.bcxin.tenant.open.infrastructures.components.IdWorker;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.enums.DeskType;
import com.bcxin.tenant.open.infrastructures.enums.DispatchReasonType;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import com.redis.om.spring.search.stream.EntityStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class RoomCommunicatedGroupUtils {
    private static final ThreadLocal<Collection<String>> _innerExceptionLocalStore = new InheritableThreadLocal<Collection<String>>();

    public static Collection<RoomCommunicatedGroupDTO> build(RoomDocumentRepository roomDocumentRepository, JsonProvider jsonProvider, Collection<Long> roomIds, Collection<TencentCallbackLogView> roomRelatedData, Collection<RoomUserEntity> roomUsers, EntityStream entityStream, BillPaymentRuleConfig billPaymentRuleConfig) {
        _innerExceptionLocalStore.set(new ArrayList());
        if (CollectionUtils.isEmpty(roomIds)) {
            return Collections.EMPTY_LIST;
        }
        Collection roomCommunicatedGroups = roomIds.stream().map(roomId -> {
            try {
                Collection matchedRoomLifeCycles = roomRelatedData.stream().filter(ix -> ix.getRoomId().equalsIgnoreCase(String.valueOf(roomId))).collect(Collectors.toList());
                Collection roomLifeCycles = matchedRoomLifeCycles.stream().filter(ii -> TencentConstants.filterRoomLifecycle(ii.getEventType())).collect(Collectors.toList());
                RoomDocument document = roomDocumentRepository.findById(roomId).orElse(null);
                DispatchReasonType referenceType = DispatchReasonType.Normal;
                String referenceNumber = "#exception";
                if (document != null) {
                    referenceNumber = document.getReferenceNumber();
                    referenceType = document.getReferenceType();
                }
                DeskType deskType = DeskType.Normal;
                if (document.getDeskType() != null) {
                    deskType = document.getDeskType();
                }
                RoomCommunicatedGroupDTO roomCommunicatedGroupDto = RoomCommunicatedGroupDTO.create(jsonProvider, deskType, String.valueOf(roomId), referenceType, referenceNumber, roomLifeCycles, roomUsers, entityStream, billPaymentRuleConfig);
                Optional<TencentCallbackLogView> startRoomOptional = roomLifeCycles.stream().filter(ii -> TencentConstants.filterStartRoom(ii.getEventType())).findFirst();
                if (!startRoomOptional.isPresent()) {
                    throw new BadTenantException(String.format("\u65e0\u6548\u623f\u95f4\u6570\u636e(%s), \u65e0\u6cd5\u627e\u5230\u5f00\u542f\u623f\u95f4\u7684\u53d1\u8d77\u4eba\u4fe1\u606f", roomId));
                }
                Collection enterExitRoomLogs = matchedRoomLifeCycles.stream().filter(ii -> TencentConstants.filterEnterRoom(ii.getEventType()) || TencentConstants.filterExitRoom(ii.getEventType())).collect(Collectors.toList());
                roomCommunicatedGroupDto.joinRooms(startRoomOptional.get(), enterExitRoomLogs, jsonProvider, roomUsers);
                Collection audioVideoLogs = matchedRoomLifeCycles.stream().filter(ii -> TencentConstants.filterStartVideoAudioAssit(ii.getEventType()) || TencentConstants.filterStopVideoAudioAssit(ii.getEventType())).collect(Collectors.toList());
                roomCommunicatedGroupDto.addAudioVideoLogs(audioVideoLogs, jsonProvider);
                return roomCommunicatedGroupDto;
            }
            catch (Exception ex) {
                Collection<String> errors = _innerExceptionLocalStore.get();
                if (errors == null) {
                    errors = new ArrayList<String>();
                }
                errors.add(String.format("\u623f\u95f4(%s) \u5904\u7406\u53d1\u751f\u5f02\u5e38:%s", roomId, ex.toString()));
                return null;
            }
        }).filter(ii -> ii != null).collect(Collectors.toList());
        return roomCommunicatedGroups;
    }

    public static void appendNoApplyRoomUsers(IdWorker idWorker, Collection<RoomCommunicatedGroupDTO> communicatedGroups, Collection<RoomUserEntity> roomUsers) {
        if (CollectionUtils.isEmpty(communicatedGroups) || CollectionUtils.isEmpty(roomUsers)) {
            return;
        }
        for (RoomCommunicatedGroupDTO group : communicatedGroups) {
            Collection selectedRoomUsers = roomUsers.stream().filter(ii -> ii.getRoomId() != null && String.valueOf(ii.getRoomId()).equalsIgnoreCase(group.getRoomId())).collect(Collectors.toList());
            Collection noAnswerRoomUsers = selectedRoomUsers.stream().filter(ic -> {
                if (ic.isSponsor()) {
                    return false;
                }
                Collection<RoomCommunicatedGroupDTO.JoinRoomUserDto> joinRoomUsers = group.getJoinRoomUsers();
                if (!CollectionUtils.isEmpty(joinRoomUsers)) {
                    return !joinRoomUsers.stream().anyMatch(ix -> ix.getInvitedUserRecordId() == ic.getId().longValue());
                }
                return true;
            }).collect(Collectors.toList());
            group.addNoAnswerRoomUsers(idWorker, noAnswerRoomUsers);
        }
    }

    public static String getCurrentProcessError() {
        Collection<String> errors = _innerExceptionLocalStore.get();
        if (CollectionUtils.isEmpty(errors)) {
            return "";
        }
        return errors.stream().collect(Collectors.joining(";"));
    }
}

