/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.services.impls;

import com.bcxin.tenant.open.document.domains.documents.RdEmployeeDocument;
import com.bcxin.tenant.open.document.domains.documents.RdSecurityStationDocument;
import com.bcxin.tenant.open.document.domains.repositories.RdEmployeeDocumentRepository;
import com.bcxin.tenant.open.document.domains.repositories.RdSecurityStationDocumentRepository;
import com.bcxin.tenant.open.document.domains.utils.GeoPointUtils;
import com.bcxin.tenant.open.domains.components.CacheProvider;
import com.bcxin.tenant.open.domains.components.HotCacheManager;
import com.bcxin.tenant.open.domains.dtos.SystemSettingDTO;
import com.bcxin.tenant.open.domains.entities.TenantEmployeeAttendanceEntity;
import com.bcxin.tenant.open.domains.repositories.AttendanceRepository;
import com.bcxin.tenant.open.domains.services.AttendanceService;
import com.bcxin.tenant.open.domains.services.commands.BatchAttendanceCommitCommand;
import com.bcxin.tenant.open.domains.services.commands.CleanRecentlyAttendanceCommitCommand;
import com.bcxin.tenant.open.domains.services.commands.CreateAttendanceCommand;
import com.bcxin.tenant.open.domains.services.commands.ValidateAttendanceCommand;
import com.bcxin.tenant.open.domains.services.commands.results.ValidateAttendanceCommandResult;
import com.bcxin.tenant.open.infrastructures.UnitWork;
import com.bcxin.tenant.open.infrastructures.components.IdWorker;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.constants.KafkaConstants;
import com.bcxin.tenant.open.infrastructures.enums.ReferenceType;
import com.bcxin.tenant.open.infrastructures.enums.ResourceType;
import com.bcxin.tenant.open.infrastructures.exceptions.NoAllowedTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.NoFoundTenantException;
import com.bcxin.tenant.open.infrastructures.utils.BusinessUtil;
import com.bcxin.tenant.open.infrastructures.valueTypes.TrafficTagValueType;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.geo.Point;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AttendanceServiceImpl
implements AttendanceService {
    private static Logger logger = LoggerFactory.getLogger(AttendanceService.class);
    private final UnitWork unitWork;
    private final AttendanceRepository attendanceRepository;
    private final RdEmployeeDocumentRepository employeeDocumentRepository;
    private final RdSecurityStationDocumentRepository securityStationDocumentRepository;
    private final JsonProvider jsonProvider;
    private final CacheProvider cacheProvider;
    private final KafkaTemplate kafkaTemplate;
    private final TrafficTagValueType tagValueType;
    private final IdWorker idWorker;

    public AttendanceServiceImpl(UnitWork unitWork, AttendanceRepository attendanceRepository, RdEmployeeDocumentRepository employeeDocumentRepository, RdSecurityStationDocumentRepository securityStationDocumentRepository, JsonProvider jsonProvider, CacheProvider cacheProvider, KafkaTemplate kafkaTemplate, TrafficTagValueType tagValueType, IdWorker idWorker) {
        this.unitWork = unitWork;
        this.attendanceRepository = attendanceRepository;
        this.employeeDocumentRepository = employeeDocumentRepository;
        this.securityStationDocumentRepository = securityStationDocumentRepository;
        this.jsonProvider = jsonProvider;
        this.cacheProvider = cacheProvider;
        this.kafkaTemplate = kafkaTemplate;
        this.tagValueType = tagValueType;
        this.idWorker = idWorker;
    }

    @Override
    public void dispatch(CreateAttendanceCommand command) {
        TenantEmployeeAttendanceEntity entity = new TenantEmployeeAttendanceEntity();
        entity.setAddress(command.getAddress());
        entity.setNote(command.getNote());
        entity.setLonLat(command.getLonLat());
        entity.setCreatedTime(Timestamp.from(Instant.now()));
        entity.setRecordStatus(command.getRecordStatus());
        entity.setAttachments(this.jsonProvider.getJson(command.getAttachments()));
        entity.setTenantEmployeeId(command.getTenantEmployeeId());
        entity.setReferenceType(command.getReferenceType());
        entity.setReferenceNumber(command.getReferenceNumber());
        entity.setTenantUserId("#1");
        entity.setOrganizationId("#1");
        entity.setExtendJsonInfo(this.jsonProvider.getJson(command.getItems()));
        try {
            entity.setHeaderAgent(command.getHeaderOptionValue().toString());
        }
        catch (Exception ex) {
            entity.setHeaderAgent(String.format("\u627e\u4e0d\u5230\u5934\u4fe1\u606f:%s", ex.getMessage()));
        }
        int partition = KafkaConstants.calculatePartition((String)entity.getTenantEmployeeId());
        String data = this.jsonProvider.getJson((Object)entity);
        this.kafkaTemplate.send("dispatch.binlog-cdc.topic.v2.attendance", Integer.valueOf(partition), (Object)entity.getTenantEmployeeId(), (Object)data);
    }

    @Override
    public ValidateAttendanceCommandResult dispatch(ValidateAttendanceCommand command) {
        ValidateAttendanceCommandResult commandResult = (ValidateAttendanceCommandResult)((Object)HotCacheManager.get(HotCacheManager.CacheDataType.SecurityStation, command.getReferenceNumber()));
        if (commandResult != null) {
            boolean enableFaceValidation = this.getEnableFaceValidation();
            commandResult.assignEnableFaceValidation(enableFaceValidation);
            return commandResult;
        }
        if (command.getReferenceType() == ReferenceType.Station) {
            if (!StringUtils.hasLength((String)command.getReferenceNumber())) {
                throw new NoFoundTenantException("\u9a7b\u52e4\u70b9/\u5c97\u70b9\u4fe1\u606f\u65e0\u6548");
            }
            RdSecurityStationDocument securityStationDocument = this.securityStationDocumentRepository.findById((Object)command.getReferenceNumber()).orElse(null);
            if (securityStationDocument == null) {
                throw new NoFoundTenantException(String.format("\u8be5\u804c\u5458\u6240\u5728\u7684\u9a7b\u52e4\u70b9\u65e0\u6548(%s)", command.getReferenceNumber()));
            }
            if (securityStationDocument.getPerformRange() == null) {
                throw new NoAllowedTenantException("\u9a7b\u52e4\u70b9\u672a\u8bbe\u7f6e\u6267\u884c\u8303\u56f4, \u56e0\u6b64\u65e0\u6cd5\u6267\u884c\u7b7e\u5230/\u7b7e\u9000\u64cd\u4f5c");
            }
            boolean ignoredPerformRangeLimited = BusinessUtil.checkIfCommunityPolicing((String)securityStationDocument.getInstitutional());
            if (BusinessUtil.isEventProject((String)securityStationDocument.getProjectId()) && securityStationDocument.getBeginDate() != null && securityStationDocument.getBeginDate().after(new Date())) {
                ignoredPerformRangeLimited = true;
            }
            commandResult = ValidateAttendanceCommandResult.create(securityStationDocument.getId(), securityStationDocument.getName(), securityStationDocument.getAddress(), securityStationDocument.getLonLat() == null ? null : Double.valueOf(securityStationDocument.getLonLat().getY()), securityStationDocument.getLonLat() == null ? null : Double.valueOf(securityStationDocument.getLonLat().getX()), securityStationDocument.getPerformRange(), ignoredPerformRangeLimited);
            boolean enableFaceValidation = this.getEnableFaceValidation();
            commandResult.assignEnableFaceValidation(enableFaceValidation);
            HotCacheManager.put(HotCacheManager.CacheDataType.SecurityStation, command.getReferenceNumber(), commandResult);
        } else {
            commandResult = this.checkAttendanceSettings();
        }
        return commandResult;
    }

    @Override
    public void dispatch(BatchAttendanceCommitCommand command) {
        Collection data = command.getData().stream().map(ii -> {
            TenantEmployeeAttendanceEntity entity = (TenantEmployeeAttendanceEntity)((Object)((Object)this.jsonProvider.toObject(TenantEmployeeAttendanceEntity.class, ii)));
            try {
                if (StringUtils.hasLength((String)entity.getHeaderAgent()) && entity.getHeaderAgent().length() > 500) {
                    entity.setHeaderAgent(entity.getHeaderAgent().substring(0, 500));
                    logger.error("\u8be5\u7b7e\u5230\u6570\u636e\u7684\u957f\u5ea6\u5927\u4e8e500:{}-{}-{}", new Object[]{entity.getTenantEmployeeId(), entity.getCreatedTime(), entity.getHeaderAgent()});
                }
            }
            catch (Exception ex) {
                logger.error("\u622a\u53d6\u7b7e\u5230\u6570\u636e\u53d1\u751f\u5f02\u5e38:{}-{}-{}", new Object[]{entity.getTenantEmployeeId(), entity.getCreatedTime(), entity.getHeaderAgent(), ex});
            }
            if (entity.getRecordStatus() == null) {
                logger.error("\u5f02\u5e38\u7b7e\u5230\u6570\u636e:empId={}-time={}-ha={}-rs={}", new Object[]{entity.getTenantEmployeeId(), entity.getCreatedTime(), entity.getHeaderAgent(), entity.getRecordStatus()});
                return null;
            }
            return entity;
        }).filter(ii -> ii.getRecordStatus() != null).collect(Collectors.toList());
        Collection employeeIds = data.stream().map(ii -> ii.getTenantEmployeeId()).distinct().collect(Collectors.toList());
        List employeeDocuments = this.employeeDocumentRepository.findAllById((Iterable)employeeIds);
        data.forEach(entity -> {
            RdEmployeeDocument document = employeeDocuments.stream().filter(ix -> ix.getId().equalsIgnoreCase(entity.getTenantEmployeeId())).findFirst().orElse(null);
            try {
                if (document != null) {
                    String superviseDepartId = "#1";
                    String superviseDepartName = "#1.";
                    Set resourceTypes = ResourceType.toResourceTypes((Set)document.getResourceTypes());
                    if (StringUtils.hasLength((String)document.getSuperviseDepartId()) && !"#1".equalsIgnoreCase(document.getSuperviseDepartId())) {
                        superviseDepartId = document.getSuperviseDepartId();
                        superviseDepartName = document.getSuperviseDepartName();
                    }
                    Point point = null;
                    if (entity.getLonLat() != null) {
                        point = GeoPointUtils.translateFromLocation((double)entity.getLonLat().getLon(), (double)entity.getLonLat().getLat());
                    }
                    document.changeDutyStatus(entity.getRecordStatus(), point);
                    entity.setTenantUserId(document.getTenantUserId());
                    entity.setOrganizationId(document.getOrganizationId());
                    entity.setName(document.getName());
                    entity.setIdCardNo(document.getIdCardNo());
                    entity.setCompanyName(document.getCompanyName());
                    entity.setSuperviseDepartId(superviseDepartId);
                    entity.setSuperviseDepartName(superviseDepartName);
                    entity.setCalculatedResourceType(ResourceType.getCalculatedResourceValue((Set)resourceTypes));
                    entity.setSecurityCertificateNo(StringUtils.hasLength((String)document.getSecurityCertificateNo()) ? document.getSecurityCertificateNo() : "#1");
                } else {
                    entity.setTenantUserId("#1");
                    entity.setOrganizationId("#1");
                    entity.setName("#1");
                    entity.setIdCardNo("#1");
                    entity.setCompanyName("#1");
                    entity.setSuperviseDepartId("#1");
                    entity.setSuperviseDepartName("#1");
                }
            }
            catch (Exception ex) {
                logger.error("\u7b7e\u5230\u6570\u5f02\u5e38:tenant-employee-id={},record-status={},time={},", new Object[]{entity.getTenantEmployeeId(), entity.getRecordStatus(), entity.getCreatedTime(), ex});
            }
        });
        data = data.stream().filter(ii -> employeeDocuments.stream().anyMatch(ix -> ix.getId().equalsIgnoreCase(ii.getTenantEmployeeId()))).collect(Collectors.toList());
        this.employeeDocumentRepository.saveAll((Iterable)employeeDocuments);
        Collection stationAttendances = data.stream().filter(ii -> ii.getReferenceType() == ReferenceType.Station).collect(Collectors.toList());
        Collection jobStations = data.stream().filter(ii -> ii.getReferenceType() == ReferenceType.JobStation).collect(Collectors.toList());
        Collection excludeStations = data.stream().filter(ii -> ii.getReferenceType() != ReferenceType.Station && ii.getReferenceType() != ReferenceType.JobStation).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty((Collection)data)) {
            String tranId = this.unitWork.beginTransaction();
            try {
                this.attendanceRepository.batchInsert(excludeStations);
                this.attendanceRepository.batchInsertForStation(stationAttendances);
                this.attendanceRepository.batchInsertForJobStation(jobStations);
                this.unitWork.commit(tranId);
            }
            catch (Exception ex) {
                this.unitWork.rollback(tranId);
                throw ex;
            }
        }
    }

    @Override
    public int dispatch(CleanRecentlyAttendanceCommitCommand command) {
        String tranId = this.unitWork.beginTransaction();
        int affectedCount = 0;
        try {
            affectedCount = this.attendanceRepository.cleanRecentlyRecords();
            this.unitWork.commit(tranId);
        }
        catch (Exception ex) {
            this.unitWork.rollback(tranId);
            throw ex;
        }
        return affectedCount;
    }

    @Override
    public boolean checkIfEnableFaceValidation() {
        return this.getEnableFaceValidation();
    }

    private ValidateAttendanceCommandResult checkAttendanceSettings() {
        ValidateAttendanceCommandResult commandResult = ValidateAttendanceCommandResult.create(null, "", "", null, null, 0.0, true);
        boolean enableFaceValidation = this.getEnableFaceValidation();
        commandResult.assignEnableFaceValidation(enableFaceValidation);
        return commandResult;
    }

    private boolean getEnableFaceValidation() {
        Boolean enableFaceValidation = (Boolean)HotCacheManager.get(HotCacheManager.CacheDataType.EnableFaceValidation, "FACE_VALIDATION_SETTING");
        if (enableFaceValidation == null) {
            try {
                SystemSettingDTO settingDTO = this.cacheProvider.get("dispatch:system:setting:cache-key", () -> SystemSettingDTO.getDefault(), SystemSettingDTO.class);
                if (settingDTO != null) {
                    enableFaceValidation = settingDTO.isEnableFaceValidation();
                    HotCacheManager.put(HotCacheManager.CacheDataType.EnableFaceValidation, "FACE_VALIDATION_SETTING", enableFaceValidation);
                }
            }
            catch (Exception ex) {
                logger.error("\u9a8c\u8bc1\u7b7e\u5230\u524d\u7f6e\u6761\u4ef6\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
            }
        }
        return enableFaceValidation;
    }
}

