/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.infrastructures.utils;

import com.alibaba.fastjson.JSONArray;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class GisPointUtil {
    private static double EARTH_RADIUS = 6378137.0;

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double getDistance(double lat1, double lng1, double lat2, double lng2) {
        double radLat1 = GisPointUtil.rad(lat1);
        double radLat2 = GisPointUtil.rad(lat2);
        double a = radLat1 - radLat2;
        double b = GisPointUtil.rad(lng1) - GisPointUtil.rad(lng2);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= EARTH_RADIUS;
        s = (double)Math.round(s * 10000.0) / 10000.0;
        return s;
    }

    public static boolean isInCircle(double lng1, double lat1, double lng2, double lat2, Double radius) {
        return GisPointUtil.getDistance(lat1, lng1, lat2, lng2) <= radius;
    }

    public static boolean isInPolygon(double pointLon, double pointLat, JSONArray points) {
        Point2D.Double point = new Point2D.Double(pointLon, pointLat);
        ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>();
        double polygonPoint_x = 0.0;
        double polygonPoint_y = 0.0;
        int len = points.size();
        for (int i = 0; i < len; ++i) {
            polygonPoint_x = points.getJSONObject(i).getDouble("x");
            polygonPoint_y = points.getJSONObject(i).getDouble("y");
            Point2D.Double polygonPoint = new Point2D.Double(polygonPoint_x, polygonPoint_y);
            pointList.add(polygonPoint);
        }
        return GisPointUtil.check(point, pointList);
    }

    private static boolean check(Point2D.Double point, List<Point2D.Double> polygon) {
        GeneralPath peneralPath = new GeneralPath();
        Point2D.Double first = polygon.get(0);
        peneralPath.moveTo(first.x, first.y);
        polygon.remove(0);
        for (Point2D.Double d : polygon) {
            peneralPath.lineTo(d.x, d.y);
        }
        peneralPath.lineTo(first.x, first.y);
        peneralPath.closePath();
        return peneralPath.contains(point);
    }

    public static void main(String[] args) {
        String points = "[{\"sets\":[{\"name\":\"sswg\",\"value\":\"402881f6681232c00168129b896e0078\"}],\"where\":[{\"name\":\"id\",\"value\":3231735,\"type\":\"=\"}]},{\"sets\":[{\"name\":\"sswg\",\"value\":\"000000006817dd6f0168313b9b89049a\"}],\"where\":[{\"name\":\"id\",\"value\":3231735,\"type\":\"=\"}]}]";
        JSONArray pointArray = (JSONArray)JSONArray.parse((String)points);
        System.out.println(GisPointUtil.isInPolygon(120.636514, 31.341752, pointArray));
    }
}

