/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.services.impls;

import com.bcxin.tenant.open.document.domains.documents.RdCompanyDocument;
import com.bcxin.tenant.open.document.domains.documents.RdEmployeeDocument;
import com.bcxin.tenant.open.document.domains.documents.RdExamSiteRoomDocument;
import com.bcxin.tenant.open.document.domains.documents.RdSecurityStationDocument;
import com.bcxin.tenant.open.document.domains.repositories.RdCompanyDocumentRepository;
import com.bcxin.tenant.open.document.domains.repositories.RdEmployeeDocumentRepository;
import com.bcxin.tenant.open.document.domains.repositories.RdExamSiteRoomDocumentRepository;
import com.bcxin.tenant.open.document.domains.repositories.RdSecurityStationDocumentRepository;
import com.bcxin.tenant.open.domains.entities.TenantContentFollowEntity;
import com.bcxin.tenant.open.domains.repositories.TenantContentFollowRepository;
import com.bcxin.tenant.open.domains.services.TenantContentFollowService;
import com.bcxin.tenant.open.domains.services.commands.CancelTenantContentFollowCommand;
import com.bcxin.tenant.open.domains.services.commands.CreateTenantContentFollowCommand;
import com.bcxin.tenant.open.infrastructure.redis.components.DistributedLockProvider;
import com.bcxin.tenant.open.infrastructures.UnitWork;
import com.bcxin.tenant.open.infrastructures.components.IdWorker;
import com.bcxin.tenant.open.infrastructures.enums.ContentFollowType;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.NoFoundTenantException;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class TenantContentFollowServiceImpl
implements TenantContentFollowService {
    private final TenantContentFollowRepository tenantContentFollowRepository;
    private final RdEmployeeDocumentRepository employeeDocumentRepository;
    private final RdSecurityStationDocumentRepository securityStationDocumentRepository;
    private final RdExamSiteRoomDocumentRepository rdExamSiteRoomDocumentRepository;
    private final DistributedLockProvider distributedLockProvider;
    private final RdCompanyDocumentRepository companyDocumentRepository;
    private final UnitWork unitWork;
    private final IdWorker idWorker;

    public TenantContentFollowServiceImpl(TenantContentFollowRepository tenantContentFollowRepository, RdEmployeeDocumentRepository employeeDocumentRepository, RdSecurityStationDocumentRepository securityStationDocumentRepository, RdCompanyDocumentRepository companyDocumentRepository, RdExamSiteRoomDocumentRepository rdExamSiteRoomDocumentRepository, DistributedLockProvider distributedLockProvider, UnitWork unitWork, IdWorker idWorker) {
        this.tenantContentFollowRepository = tenantContentFollowRepository;
        this.employeeDocumentRepository = employeeDocumentRepository;
        this.securityStationDocumentRepository = securityStationDocumentRepository;
        this.rdExamSiteRoomDocumentRepository = rdExamSiteRoomDocumentRepository;
        this.companyDocumentRepository = companyDocumentRepository;
        this.distributedLockProvider = distributedLockProvider;
        this.unitWork = unitWork;
        this.idWorker = idWorker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(CreateTenantContentFollowCommand command) {
        command.validate();
        String distributedLockKey = TenantContentFollowServiceImpl.getDistributedLockKey(command.getContentFollowId(), command.getFollowType());
        switch (command.getFollowType()) {
            case Employee: {
                Optional employeeDocumentOptional = this.employeeDocumentRepository.findById((Object)command.getContentFollowId());
                if (!employeeDocumentOptional.isPresent()) {
                    throw new NoFoundTenantException("\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u9a7b\u52e4\u70b9");
                }
                RdEmployeeDocument document = (RdEmployeeDocument)employeeDocumentOptional.get();
                if (!document.addFollowedDeviceNo(command.getDeviceNo())) break;
                this.distributedLockProvider.lock(distributedLockKey);
                try {
                    this.employeeDocumentRepository.save((Object)document);
                    break;
                }
                finally {
                    this.distributedLockProvider.release(distributedLockKey);
                }
            }
            case Station: {
                Optional securityStationDocumentOptional = this.securityStationDocumentRepository.findById((Object)command.getContentFollowId());
                if (!securityStationDocumentOptional.isPresent()) {
                    throw new NoFoundTenantException("\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u9a7b\u52e4\u70b9");
                }
                RdEmployeeDocument document = (RdSecurityStationDocument)securityStationDocumentOptional.get();
                if (!document.addFollowedDeviceNo(command.getDeviceNo())) break;
                this.distributedLockProvider.lock(distributedLockKey);
                try {
                    this.securityStationDocumentRepository.save((Object)document);
                    break;
                }
                finally {
                    this.distributedLockProvider.release(distributedLockKey);
                }
            }
            case Company: {
                Optional companyDocumentOptional = this.companyDocumentRepository.findById((Object)command.getContentFollowId());
                if (!companyDocumentOptional.isPresent()) {
                    throw new NoFoundTenantException("\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u5355\u4f4d");
                }
                RdEmployeeDocument document = (RdCompanyDocument)companyDocumentOptional.get();
                if (!document.addFollowedDeviceNo(command.getDeviceNo())) break;
                this.distributedLockProvider.lock(distributedLockKey);
                try {
                    this.companyDocumentRepository.save((Object)document);
                    break;
                }
                finally {
                    this.distributedLockProvider.release(distributedLockKey);
                }
            }
            case ExamSiteRoom: {
                RdExamSiteRoomDocument document = this.rdExamSiteRoomDocumentRepository.findById((Object)command.getContentFollowId()).orElse(null);
                if (document == null) {
                    throw new NoFoundTenantException("\u627e\u4e0d\u5230\u8be5\u8003\u573a\u4fe1\u606f");
                }
                if (!document.addFollowedDeviceNo(command.getDeviceNo())) break;
                this.distributedLockProvider.lock(distributedLockKey);
                try {
                    this.rdExamSiteRoomDocumentRepository.save((Object)document);
                    break;
                }
                finally {
                    this.distributedLockProvider.release(distributedLockKey);
                }
            }
        }
        String tranId = this.unitWork.beginTransaction();
        try {
            TenantContentFollowEntity contentFollow = TenantContentFollowEntity.create(this.idWorker.getNextId(), command.getFollowType(), command.getContentFollowId(), command.getDeviceNo(), command.getFollowUserId());
            this.tenantContentFollowRepository.upset(contentFollow);
            this.unitWork.commit(tranId);
        }
        catch (Exception ex) {
            this.unitWork.rollback(tranId);
            throw new BadTenantException("\u65e0\u6cd5\u63d0\u4ea4\u5173\u6ce8\u4fe1\u606f\u6570\u636e", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(CancelTenantContentFollowCommand command) {
        command.validate();
        String distributedLockKey = TenantContentFollowServiceImpl.getDistributedLockKey(command.getContentFollowId(), command.getFollowType());
        switch (command.getFollowType()) {
            case Employee: {
                Optional employeeDocumentOptional = this.employeeDocumentRepository.findById((Object)command.getContentFollowId());
                if (!employeeDocumentOptional.isPresent()) {
                    throw new NoFoundTenantException("\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u804c\u5458\u4fe1\u606f");
                }
                RdEmployeeDocument document = (RdEmployeeDocument)employeeDocumentOptional.get();
                if (!document.removeFollowedDeviceNo(command.getDeviceNo())) break;
                this.distributedLockProvider.lock(distributedLockKey);
                try {
                    this.employeeDocumentRepository.save((Object)document);
                    break;
                }
                finally {
                    this.distributedLockProvider.release(distributedLockKey);
                }
            }
            case Station: {
                Optional securityStationDocumentOptional = this.securityStationDocumentRepository.findById((Object)command.getContentFollowId());
                if (!securityStationDocumentOptional.isPresent()) {
                    throw new NoFoundTenantException("\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u9a7b\u52e4\u70b9");
                }
                RdEmployeeDocument document = (RdSecurityStationDocument)securityStationDocumentOptional.get();
                if (!document.removeFollowedDeviceNo(command.getDeviceNo())) break;
                this.distributedLockProvider.lock(distributedLockKey);
                try {
                    this.securityStationDocumentRepository.save((Object)document);
                    break;
                }
                finally {
                    this.distributedLockProvider.release(distributedLockKey);
                }
            }
            case Company: {
                Optional companyDocumentOptional = this.companyDocumentRepository.findById((Object)command.getContentFollowId());
                if (!companyDocumentOptional.isPresent()) {
                    throw new NoFoundTenantException("\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u5355\u4f4d");
                }
                RdEmployeeDocument document = (RdCompanyDocument)companyDocumentOptional.get();
                if (!document.removeFollowedDeviceNo(command.getDeviceNo())) break;
                this.distributedLockProvider.lock(distributedLockKey);
                try {
                    this.companyDocumentRepository.save((Object)document);
                    break;
                }
                finally {
                    this.distributedLockProvider.release(distributedLockKey);
                }
            }
            case ExamSiteRoom: {
                RdExamSiteRoomDocument document = this.rdExamSiteRoomDocumentRepository.findById((Object)command.getContentFollowId()).orElse(null);
                if (document == null) {
                    throw new NoFoundTenantException("\u627e\u4e0d\u5230\u8be5\u8003\u573a\u4fe1\u606f");
                }
                if (!document.removeFollowedDeviceNo(command.getDeviceNo())) break;
                this.distributedLockProvider.lock(distributedLockKey);
                try {
                    this.rdExamSiteRoomDocumentRepository.save((Object)document);
                    break;
                }
                finally {
                    this.distributedLockProvider.release(distributedLockKey);
                }
            }
        }
        TenantContentFollowEntity contentFollow = this.tenantContentFollowRepository.findByUniqueValue(command.getFollowType(), command.getContentFollowId(), command.getDeviceNo());
        if (contentFollow == null) {
            throw new NoFoundTenantException(String.format("\u65e0\u6cd5\u627e\u5230\u5173\u6ce8(%s)\u7684\u5185\u5bb9", command.getContentFollowId()));
        }
        String tranId = this.unitWork.beginTransaction();
        try {
            contentFollow.markUnfollowed(command.getFollowUserId());
            this.tenantContentFollowRepository.upset(contentFollow);
            this.unitWork.commit(tranId);
        }
        catch (Exception ex) {
            this.unitWork.rollback(tranId);
            throw new BadTenantException("\u53d6\u6d88\u5173\u6ce8\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
        }
    }

    private static String getDistributedLockKey(String contentFollowId, ContentFollowType followType) {
        String distributedLockKey = String.format("tfm_%s_%s", contentFollowId, followType);
        return distributedLockKey;
    }
}

