/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.services.impls;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bcxin.tenant.open.domains.entities.BillPaymentRecordEntity;
import com.bcxin.tenant.open.domains.entities.MonthlyBillEntity;
import com.bcxin.tenant.open.domains.entities.OrgPurseEntity;
import com.bcxin.tenant.open.domains.entities.OrgPurseTransactionEntity;
import com.bcxin.tenant.open.domains.repositories.BillPaymentRecordRepository;
import com.bcxin.tenant.open.domains.repositories.MonthlyBillRepository;
import com.bcxin.tenant.open.domains.repositories.OrgPurseRepository;
import com.bcxin.tenant.open.domains.repositories.OrgPurseTransactionRepository;
import com.bcxin.tenant.open.domains.services.OrgPurseTransactionService;
import com.bcxin.tenant.open.domains.services.commands.CreateOrgPurseTransactionCommand;
import com.bcxin.tenant.open.domains.services.commands.GenerateMonthlyBillOrgPurseTransactionCommand;
import com.bcxin.tenant.open.domains.services.commands.RechargeOrgPurseTransactionCommand;
import com.bcxin.tenant.open.domains.utils.OrgPurseTransactionUtil;
import com.bcxin.tenant.open.infrastructures.UnitWork;
import com.bcxin.tenant.open.infrastructures.components.IdWorker;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.components.RetryProvider;
import com.bcxin.tenant.open.infrastructures.enums.BillPaymentStatus;
import com.bcxin.tenant.open.infrastructures.exceptions.RetryableTenantException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrgPurseTransactionServiceImpl
implements OrgPurseTransactionService {
    private final Object $lock = new Object[0];
    private final Logger logger = LoggerFactory.getLogger(OrgPurseTransactionServiceImpl.class);
    private final OrgPurseTransactionRepository orgPurseTransactionRepository;
    private final OrgPurseRepository orgPurseRepository;
    private final MonthlyBillRepository monthlyBillRepository;
    private final BillPaymentRecordRepository billPaymentRecordRepository;
    private final IdWorker idWorker;
    private final JsonProvider jsonProvider;
    private final RetryProvider retryProvider;
    private final UnitWork unitWork;

    public OrgPurseTransactionServiceImpl(OrgPurseTransactionRepository orgPurseTransactionRepository, OrgPurseRepository orgPurseRepository, MonthlyBillRepository monthlyBillRepository, BillPaymentRecordRepository billPaymentRecordRepository, IdWorker idWorker, JsonProvider jsonProvider, RetryProvider retryProvider, UnitWork unitWork) {
        this.orgPurseTransactionRepository = orgPurseTransactionRepository;
        this.orgPurseRepository = orgPurseRepository;
        this.monthlyBillRepository = monthlyBillRepository;
        this.billPaymentRecordRepository = billPaymentRecordRepository;
        this.idWorker = idWorker;
        this.jsonProvider = jsonProvider;
        this.retryProvider = retryProvider;
        this.unitWork = unitWork;
    }

    @Override
    public void dispatch(CreateOrgPurseTransactionCommand command) {
        String tranId = this.unitWork.beginTransaction();
        try {
            this.orgPurseTransactionRepository.batchInsert(command.getOrgPurseTransactions());
            this.unitWork.commit(tranId);
        }
        catch (Exception ex) {
            this.unitWork.rollback(tranId);
            throw ex;
        }
    }

    @Override
    public void dispatch(GenerateMonthlyBillOrgPurseTransactionCommand command) {
        List<MonthlyBillEntity> billEntities = this.monthlyBillRepository.getRequiredPaymentBills();
        this.chargeBills(billEntities);
    }

    @Override
    public void monthlyBillCharge(RechargeOrgPurseTransactionCommand command) {
        Collection<String> orgIds = command.getOrgIds();
        List<MonthlyBillEntity> billEntities = this.monthlyBillRepository.getRequiredPaymentBillsByOrgs(orgIds);
        this.chargeBills(billEntities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void chargeBills(List<MonthlyBillEntity> billEntities) {
        Object object = this.$lock;
        synchronized (object) {
            if (CollectionUtils.isEmpty(billEntities)) {
                return;
            }
            Map<String, List<MonthlyBillEntity>> billsMap = billEntities.stream().collect(Collectors.groupingBy(MonthlyBillEntity::getOrgId));
            Collection<OrgPurseEntity> orgPurses = this.orgPurseRepository.getByOrganizationIds(billsMap.keySet());
            for (OrgPurseEntity orgPurse : orgPurses) {
                try {
                    this.retryProvider.doExecute(() -> {
                        Optional<OrgPurseEntity> orgPurseOptional = this.orgPurseRepository.getByOrganizationIds(Arrays.asList(orgPurse.getOrganizationId())).stream().findFirst();
                        if (orgPurseOptional.isPresent()) {
                            this.chargeOrganizationBills((List)billsMap.get(orgPurse.getOrganizationId()), orgPurseOptional.get());
                        }
                        return null;
                    });
                }
                catch (Exception e) {
                    this.logger.error("\u516c\u53f8{}\u7684\u6708\u5ea6\u8d26\u5355\u81ea\u52a8\u6263\u8d39\u5931\u8d25", (Object)orgPurse.getOrganizationName(), (Object)e);
                }
            }
        }
    }

    @Override
    public void chargeOrganizationBills(List<MonthlyBillEntity> billsList, OrgPurseEntity orgPurse) {
        if (CollectionUtils.isEmpty(billsList) || orgPurse.getPoints() <= 0L) {
            return;
        }
        String transactionId = this.unitWork.beginTransaction();
        try {
            long oldPoints;
            long remainPoints = oldPoints = orgPurse.getPoints().longValue();
            List bills = billsList.stream().map(ix -> {
                try {
                    return ix.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            ArrayList<OrgPurseTransactionEntity> orgPurseTransactions = new ArrayList<OrgPurseTransactionEntity>();
            ArrayList<MonthlyBillEntity> updatedBills = new ArrayList<MonthlyBillEntity>();
            ArrayList<BillPaymentRecordEntity> billPaymentRecordEntities = new ArrayList<BillPaymentRecordEntity>();
            for (MonthlyBillEntity bill : bills) {
                if (remainPoints <= 0L) break;
                OrgPurseTransactionEntity transaction = OrgPurseTransactionUtil.build(this.idWorker, bill, this.jsonProvider, remainPoints, orgPurse.getOrganizationName());
                remainPoints += transaction.getPoints().longValue();
                bill.setPaidAmount(bill.getPaidAmount() - transaction.getPoints().intValue());
                bill.setPaidTime(Timestamp.from(Instant.now()));
                bill.setBillPaymentStatus(bill.getPaidAmount() == 0 ? BillPaymentStatus.Unpaid : (bill.getPaidAmount().equals(bill.getAmount()) ? BillPaymentStatus.Paid : BillPaymentStatus.PartialPaid));
                BillPaymentRecordEntity paymentRecord = BillPaymentRecordEntity.create(bill.getBillId(), 0 - transaction.getPoints().intValue(), bill.getOrgId());
                orgPurseTransactions.add(transaction);
                updatedBills.add(bill);
                billPaymentRecordEntities.add(paymentRecord);
            }
            this.orgPurseTransactionRepository.batchInsertWithoutUpdateOrgPurse(orgPurseTransactions);
            this.monthlyBillRepository.updatePaidAmount(updatedBills);
            this.billPaymentRecordRepository.batchInsert(billPaymentRecordEntities);
            orgPurse.addPoints(remainPoints - oldPoints, orgPurseTransactions.stream().map(ix -> ix.getId()).collect(Collectors.joining(";")));
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(OrgPurseEntity::getPoints, (Object)oldPoints);
            wrapper.eq(OrgPurseEntity::getId, (Object)orgPurse.getId());
            int affectedCount = this.orgPurseRepository.update(orgPurse, (LambdaUpdateWrapper<OrgPurseEntity>)wrapper);
            if (affectedCount <= 0) {
                throw new RetryableTenantException("\u66f4\u65b0\u4f01\u4e1a\u94b1\u5305\u5931\u8d25");
            }
            this.unitWork.commit(transactionId);
        }
        catch (Exception e) {
            this.unitWork.rollback(transactionId);
            throw new RetryableTenantException(String.format("\u6708\u5ea6\u8d26\u5355\u81ea\u52a8\u6263\u8d39\u5f02\u5e38,\u516c\u53f8\uff1a%s", orgPurse.getOrganizationId()), e);
        }
    }
}

