package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RailRuleType;
import com.bcxin.tenant.open.infrastructures.enums.RailShapeType;
import com.bcxin.tenant.open.infrastructures.valueTypes.RdSecurityStationRailSnapshootValueType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

@Schema(name = "SecurityStationRailDetailResponse",title = "SecurityStationRailDetailResponse 电子围栏详情信息")
@Getter
public class SecurityStationRailDetailResponse extends ResponseAbstract {
    @Schema(name = "id", title = "电子围栏id")
    private final String id;

    @Schema(name = "name", title = "电子围栏名称")
    private final String name;

    @Schema(name = "beginTime",title = "开始时间")
    private final String beginTime;

    @Schema(name = "endTime",title = "结束时间")
    private final String endTime;

    @Schema(name = "countOfSecurityMan", title = "驻勤人数")
    private final Long countOfSecurityMan;

    @Schema(name = "stationId",title = "驻勤点id")
    private final String stationId;

    @Schema(name = "companyName", title = "企业名称")
    private final String companyName;

    @Schema(name = "creator",title = "创建人")
    private final String creator;

    @Schema(name = "organizationId",title = "企业id")
    private final String organizationId;

    @Schema(name = "stationName",title = "驻勤点名称")
    private final String stationName;

    @Schema(name = "railShapeType",title = "围栏形状")
    private final RailShapeType railShapeType;

    @Schema(name = "ruleType", title = "围栏类型")
    private final RailRuleType ruleType;

    @Schema(name = "ruleTypeText", title = "围栏类型-文本")
    public String getRuleTypeText() {
        return ruleType == null ? "" : ruleType.getTypeName();
    }

    @Schema(name = "locationValue",title = "围栏形状参数")
    private final RdSecurityStationRailSnapshootValueType.ShapedLocationValueType locationValue;

    public SecurityStationRailDetailResponse(Long id,
                                             String name,
                                             String beginTime,
                                             String endTime,
                                             Long countOfSecurityMan,
                                             String stationId,
                                             String companyName,
                                             String creator,
                                             String organizationId,
                                             String stationName,
                                             RailShapeType shapeType,
                                             RailRuleType ruleType,
                                             RdSecurityStationRailSnapshootValueType.ShapedLocationValueType locationValue) {
        this.id = String.valueOf(id);
        this.name = name;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.countOfSecurityMan = countOfSecurityMan;
        this.stationId = stationId;
        this.companyName = companyName;
        this.creator = creator;
        this.organizationId = organizationId;
        this.stationName = stationName;
        this.railShapeType = shapeType;
        this.ruleType = ruleType;
        this.locationValue = locationValue;
    }

    public static SecurityStationRailDetailResponse create(Long id,
                                                    String name,
                                                    String beginTime,
                                                    String endTime,
                                                    Long countOfSecurityMan,
                                                    String stationId,
                                                    String companyName,
                                                    String creator,String organizationId,
                                                    String stationName,
                                                    RailShapeType shapeType,
                                                    RailRuleType ruleType,
                                                    RdSecurityStationRailSnapshootValueType.ShapedLocationValueType locationValue) {
        return new SecurityStationRailDetailResponse(id, name, beginTime, endTime, countOfSecurityMan,
                stationId, companyName, creator, organizationId,
                stationName, shapeType, ruleType,locationValue);
    }
}
