package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;

@Schema(name = "ProjectAdvanceSearchResponse",title = "业务管理-高级项目信息")
@Getter
public class ProjectResponse extends ResponseAbstract {
    @Schema(name = "pkId", title = "pkId")
    private final Long pkId;

    @Schema(name = "id", title = "id")
    private final String id;
    @Schema(name = "name", title = "项目名称")
    private final String name;

    @Schema(name = "type", title = "项目类型")
    private final String type;
    @Schema(name = "statusLabel", title = "项目状态")
    private final String statusLabel;
    @Schema(name = "principalName", title = "负责人")
    private final String principalName;

    @Schema(name = "organizationId", title = "企业Id")
    private final String organizationId;
    @Schema(name = "companyName", title = "企业名称")
    private final String companyName;
    @Schema(name = "address", title = "项目地址")
    private final String address;
    @Schema(name = "countOfMembers", title = "成员数量")
    private final int countOfMembers;
    @Schema(name = "countOfTeams", title = "团队数量")
    private final int countOfTeams;
    @Schema(name = "beginDate", title = "开始时间")
    private final String beginDate;
    @Schema(name = "endDate", title = "结束时间")
    private final String endDate;
    @Schema(name = "countOfStations", title = "岗点数量")
    private final long countOfStations;

    public ProjectResponse(Long pkId,
                           String id, String name,
                           String type, String principalName,
                           String organizationId,
                           String companyName,
                           String address, int countOfMembers,
                           int countOfTeams, Date beginDate,
                           Date endDate, long countOfStations) {
        this.pkId = pkId;
        this.id = id;
        this.name = name;
        this.type = type;
        this.principalName = principalName;
        this.organizationId = organizationId;
        this.companyName = companyName;
        this.address = address;
        this.countOfMembers = countOfMembers;
        this.countOfTeams = countOfTeams;

        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

        this.beginDate = dateFormat.format(beginDate);
        this.endDate = dateFormat.format(endDate);
        this.countOfStations = countOfStations;

        String label = "正常";
        var now = Timestamp.from(Instant.now());
        if (endDate.before(now)) {
            label = "已结束";
        } else if (beginDate.before(now)) {
            label = "未开始";
        }

        this.statusLabel = label;
    }

    public static ProjectResponse create(Long pkId, String id, String name, String type,
                                         String principalName,
                                         String organizationId,
                                         String companyName,
                                         String address, int countOfMembers,
                                         int countOfTeams, Date beginDate,
                                         Date endDate, long countOfStations) {
        return new ProjectResponse(pkId, id, name, type,
                principalName,organizationId, companyName, address, countOfMembers, countOfTeams, beginDate, endDate, countOfStations);
    }
}
